/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCTypeProvider;
import io.vertx.ext.jdbc.impl.actions.SQLValueProvider;
import io.vertx.ext.jdbc.spi.JDBCDecoder;
import io.vertx.sqlclient.Tuple;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public class JDBCDecoderImpl
implements JDBCDecoder {
    private static final Logger log = LoggerFactory.getLogger(JDBCDecoder.class);

    @Override
    public Object parse(ResultSet rs, int pos, JDBCTypeProvider jdbcTypeLookup) throws SQLException {
        return this.decode(jdbcTypeLookup.apply(pos), cls -> cls == null ? rs.getObject(pos) : rs.getObject(pos, cls));
    }

    @Override
    public Object parse(CallableStatement cs, int pos, JDBCTypeProvider jdbcTypeLookup) throws SQLException {
        return this.decode(jdbcTypeLookup.apply(pos), cls -> cls == null ? cs.getObject(pos) : cs.getObject(pos, cls));
    }

    @Override
    public Object decode(JDBCType jdbcType, SQLValueProvider valueProvider) throws SQLException {
        switch (jdbcType) {
            case ARRAY: {
                return this.cast(this.getCoerceObject(valueProvider, java.sql.Array.class));
            }
            case BLOB: {
                return this.cast(this.getCoerceObject(valueProvider, Blob.class));
            }
            case CLOB: 
            case NCLOB: {
                return this.cast(this.getCoerceObject(valueProvider, Clob.class));
            }
            case BIT: 
            case BOOLEAN: {
                return this.cast(this.getCoerceObject(valueProvider, Boolean.class));
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case LONGNVARCHAR: {
                return this.cast(this.getCoerceObject(valueProvider, String.class));
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case NUMERIC: 
            case DECIMAL: {
                return this.convertNumber(valueProvider, jdbcType);
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return this.convertDateTime(valueProvider, jdbcType);
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                return this.convertBinary(valueProvider, jdbcType);
            }
            case DATALINK: {
                return this.convertLink(valueProvider);
            }
            case ROWID: {
                return this.cast(this.getCoerceObject(valueProvider, RowId.class));
            }
            case REF: {
                return this.cast(this.getCoerceObject(valueProvider, Ref.class));
            }
            case SQLXML: {
                return this.convertXML(valueProvider);
            }
            case STRUCT: {
                return this.convertStruct(valueProvider);
            }
            case NULL: 
            case OTHER: 
            case DISTINCT: 
            case REF_CURSOR: 
            case JAVA_OBJECT: {
                log.debug((Object)("Fallback to string when handle JDBCType " + jdbcType));
            }
        }
        return this.convertSpecialType(valueProvider, jdbcType);
    }

    @Override
    public Object cast(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            return this.convertArray((java.sql.Array)value);
        }
        if (value instanceof Blob) {
            Blob v = (Blob)value;
            return v.length() == 0L ? Buffer.buffer((int)0) : this.streamToBuffer(v.getBinaryStream(), Blob.class);
        }
        if (value instanceof Clob) {
            Clob v = (Clob)value;
            return v.length() == 0L ? "" : this.streamToBuffer(v.getAsciiStream(), Clob.class).toString();
        }
        if (value instanceof Ref) {
            return this.cast(((Ref)value).getObject());
        }
        if (value instanceof RowId) {
            return ((RowId)value).getBytes();
        }
        if (value instanceof Struct) {
            return Tuple.of((Object)((Struct)value).getAttributes());
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object convertArray(java.sql.Array value) throws SQLException {
        JDBCType baseType = JDBCType.valueOf(value.getBaseType());
        try {
            Object arr = value.getArray();
            if (arr != null) {
                int len = Array.getLength(arr);
                Object[] castedArray = new Object[len];
                for (int i = 0; i < len; ++i) {
                    int index = i;
                    castedArray[i] = this.decode(baseType, cls -> Array.get(arr, index));
                }
                Object[] objectArray = castedArray;
                return objectArray;
            }
            java.sql.Array array = value;
            return array;
        }
        finally {
            value.free();
        }
    }

    protected Object convertDateTime(SQLValueProvider valueProvider, JDBCType jdbcType) throws SQLException {
        try {
            return this.cast(valueProvider.apply(JDBCStatementHelper.LOOKUP_SQL_DATETIME.apply(jdbcType)));
        }
        catch (SQLException e) {
            log.debug((Object)"Error when convert SQL date time. Try coerce value", (Throwable)e);
            Object value = valueProvider.apply(null);
            if (value == null) {
                return null;
            }
            try {
                if (value instanceof Time) {
                    return ((Time)value).toLocalTime().atOffset(ZoneOffset.UTC);
                }
                if (jdbcType == JDBCType.TIME || jdbcType == JDBCType.TIME_WITH_TIMEZONE) {
                    return LocalTime.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_TIME).atOffset(ZoneOffset.UTC);
                }
                if (value instanceof Timestamp) {
                    return ((Timestamp)value).toLocalDateTime().atOffset(ZoneOffset.UTC);
                }
                if (jdbcType == JDBCType.TIMESTAMP || jdbcType == JDBCType.TIMESTAMP_WITH_TIMEZONE) {
                    return LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME).atOffset(ZoneOffset.UTC);
                }
            }
            catch (DateTimeParseException ex) {
                log.debug((Object)"Error when coerce date time value", (Throwable)ex);
            }
            return this.cast(value);
        }
    }

    protected Object convertNumber(SQLValueProvider valueProvider, JDBCType jdbcType) throws SQLException {
        try {
            return this.cast(valueProvider.apply(JDBCStatementHelper.LOOKUP_SQL_NUMBER.apply(jdbcType)));
        }
        catch (SQLException e) {
            log.debug((Object)"Error when convert SQL number", (Throwable)e);
            return this.cast(valueProvider.apply(null));
        }
    }

    protected Object convertBinary(SQLValueProvider valueProvider, JDBCType jdbcType) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, byte[].class);
        return v instanceof byte[] ? Buffer.buffer((byte[])((byte[])v)) : this.cast(v);
    }

    protected Object convertStruct(SQLValueProvider valueProvider) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, Struct.class);
        if (v instanceof Struct) {
            return this.cast(v);
        }
        return this.convertSpecialType(valueProvider, JDBCType.STRUCT);
    }

    protected Object convertLink(SQLValueProvider valueProvider) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, URL.class);
        if (v instanceof URL) {
            return v;
        }
        if (v instanceof String) {
            try {
                return new URL((String)v);
            }
            catch (MalformedURLException e) {
                throw new SQLException("Unable read data link", e);
            }
        }
        return this.cast(v);
    }

    protected Object convertXML(SQLValueProvider valueProvider) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, SQLXML.class);
        if (v instanceof SQLXML) {
            return this.streamToBuffer(((SQLXML)v).getBinaryStream(), SQLXML.class);
        }
        return this.convertSpecialType(valueProvider, JDBCType.SQLXML);
    }

    protected Object convertSpecialType(SQLValueProvider valueProvider, JDBCType jdbcType) throws SQLException {
        return Optional.ofNullable(this.cast(valueProvider.apply(null))).map(Object::toString).orElse(null);
    }

    protected Object getCoerceObject(SQLValueProvider valueProvider, Class<?> cls) throws SQLException {
        try {
            return valueProvider.apply(null);
        }
        catch (SQLException e) {
            return valueProvider.apply(cls);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Buffer streamToBuffer(InputStream is, Class<?> dataTypeClass) throws SQLException {
        try (InputStream in = is;){
            int l;
            Buffer buffer = Buffer.buffer((int)1024);
            byte[] buf = new byte[1024];
            while ((l = in.read(buf)) > -1) {
                buffer.appendBytes(buf, 0, l);
            }
            Buffer buffer2 = buffer;
            return buffer2;
        }
        catch (IOException ioe) {
            throw new SQLException("Unable to read binary stream from " + dataTypeClass.getName(), ioe);
        }
    }
}

