/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCTypeProvider;
import io.vertx.ext.jdbc.spi.JDBCDecoder;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.impl.JDBCRow;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDesc;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class JDBCQueryAction<C, R>
extends AbstractJDBCAction<JDBCResponse<R>> {
    private final Collector<Row, C, R> collector;

    public JDBCQueryAction(JDBCStatementHelper helper, SQLOptions options, Collector<Row, C, R> collector) {
        super(helper, options);
        this.collector = collector;
    }

    protected JDBCResponse<R> decode(Statement statement, boolean returnedResultSet, boolean returnedKeys, List<Integer> out) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(statement.getUpdateCount());
        if (returnedResultSet) {
            while (returnedResultSet) {
                try (ResultSet rs = statement.getResultSet();){
                    this.decodeResultSet(rs, response);
                }
                if (returnedKeys) {
                    this.decodeReturnedKeys(statement, response);
                }
                returnedResultSet = statement.getMoreResults();
            }
        } else {
            this.collector.accumulator();
            C container = this.collector.supplier().get();
            response.empty(this.collector.finisher().apply(container));
            if (returnedKeys) {
                this.decodeReturnedKeys(statement, response);
            }
        }
        if (out.size() > 0) {
            this.decodeOutput((CallableStatement)statement, out, response);
        }
        return response;
    }

    protected JDBCResponse<R> decode(Statement statement, int[] returnedBatchResult, boolean returnedKeys) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(returnedBatchResult.length);
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        RowDesc desc = new RowDesc(Collections.emptyList());
        C container = this.collector.supplier().get();
        for (int result : returnedBatchResult) {
            JDBCRow row = new JDBCRow(desc);
            row.addValue(result);
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, returnedBatchResult.length);
        if (returnedBatchResult.length != 0 && returnedKeys) {
            this.decodeReturnedKeys(statement, response);
        }
        return response;
    }

    private void decodeResultSet(ResultSet rs, JDBCResponse<R> response) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        int size = 0;
        JDBCTypeProvider provider = JDBCTypeProvider.fromResult(rs);
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            ++size;
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= cols; ++i) {
                row.addValue(this.helper.getDecoder().parse(rs, i, provider));
            }
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, size);
    }

    private R decodeRawResultSet(ResultSet rs) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        JDBCTypeProvider provider = JDBCTypeProvider.fromResult(rs);
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= cols; ++i) {
                row.addValue(this.helper.getDecoder().parse(rs, i, provider));
            }
            accumulator.accept(container, row);
        }
        return this.collector.finisher().apply(container);
    }

    private void decodeOutput(CallableStatement cs, List<Integer> out, JDBCResponse<R> output) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        C container = this.collector.supplier().get();
        JDBCRow row = new JDBCRow(new RowDesc(Collections.emptyList()));
        JDBCDecoder decoder = this.helper.getDecoder();
        JDBCTypeProvider provider = JDBCTypeProvider.fromParameter(cs);
        for (Integer idx : out) {
            Object o = cs.getObject(idx);
            if (o instanceof ResultSet) {
                row.addValue(this.decodeRawResultSet((ResultSet)o));
                continue;
            }
            row.addValue(decoder.parse(cs, (int)idx, provider));
        }
        accumulator.accept(container, row);
        R result = this.collector.finisher().apply(container);
        output.outputs(result, null, 1);
    }

    private void decodeReturnedKeys(Statement statement, JDBCResponse<R> response) throws SQLException {
        JDBCRow keys = null;
        ResultSet keysRS = statement.getGeneratedKeys();
        if (keysRS != null && keysRS.next()) {
            JDBCTypeProvider provider = JDBCTypeProvider.fromResult(keysRS);
            ResultSetMetaData metaData = keysRS.getMetaData();
            if (metaData != null) {
                int cols = metaData.getColumnCount();
                if (cols > 0) {
                    int i;
                    ArrayList<String> keysColumnNames = new ArrayList<String>();
                    RowDesc keysDesc = new RowDesc(keysColumnNames);
                    for (i = 1; i <= cols; ++i) {
                        keysColumnNames.add(metaData.getColumnLabel(i));
                    }
                    keys = new JDBCRow(keysDesc);
                    for (i = 1; i <= cols; ++i) {
                        keys.addValue(this.helper.getDecoder().parse(keysRS, i, provider));
                    }
                }
                response.returnedKeys(keys);
            }
        }
    }

    boolean returnAutoGeneratedKeys(Connection conn) {
        boolean autoGeneratedIndexes;
        boolean autoGeneratedKeys = this.options == null || this.options.isAutoGeneratedKeys();
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null && this.options.getAutoGeneratedKeysIndexes().size() > 0;
        if (autoGeneratedKeys || autoGeneratedIndexes) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd != null) {
                    return dbmd.supportsGetGeneratedKeys();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }
}

