/*
 * Decompiled with CFR 0.152.
 */
package io.vertx;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ThreadLeakCheckerRule
implements TestRule {
    private final Predicate<Thread> predicate;

    public ThreadLeakCheckerRule() {
        this(t -> t.getName().equals("vertx-jdbc-service-get-connection-thread") || t.getName().startsWith("C3P0PooledConnectionPoolManager"));
    }

    public ThreadLeakCheckerRule(Predicate<Thread> predicate) {
        this.predicate = predicate;
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ThreadLeakCheckerRule.this.check("before");
                statement.evaluate();
                ThreadLeakCheckerRule.this.check("after");
            }
        };
    }

    private void check(String when) {
        List<Thread> threads;
        long start = System.nanoTime();
        while (true) {
            if ((threads = ThreadLeakCheckerRule.findThreads(this.predicate)).isEmpty()) {
                return;
            }
            long stop = System.nanoTime();
            if (TimeUnit.SECONDS.convert(stop - start, TimeUnit.NANOSECONDS) >= 5L) break;
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        StringBuilder msg = new StringBuilder(threads.stream().map(t -> t.getName() + ": state=" + t.getState().name() + "/alive=" + t.isAlive()).collect(Collectors.joining(", ", "Unexpected threads " + when + " test:", ".")));
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo ti : threadMxBean.dumpAllThreads(true, true)) {
            msg.append(System.getProperty("line.separator")).append(ti.toString());
        }
        Assert.fail((String)msg.toString());
    }

    public static List<Thread> findThreads(Predicate<Thread> predicate) {
        return Thread.getAllStackTraces().keySet().stream().filter(predicate).collect(Collectors.toList());
    }
}

