/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.DBConfigs;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.jdbc.spi.impl.C3P0DataSourceProvider;
import io.vertx.ext.sql.SQLConnection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.junit.BeforeClass;
import org.junit.Test;

public class CloseTest
extends JDBCClientTestBase {
    private static final JsonObject theConfig = DBConfigs.hsqldb(CloseTest.class);
    private static DataSource ds;

    @BeforeClass
    public static void createDb() throws Exception {
        CloseTest.resetDb(CloseTest.class);
    }

    @Test
    public void testUsingNonSharedInVerticle() throws Exception {
        CompletableFuture id = new CompletableFuture();
        this.vertx.deployVerticle(NonSharedClientVerticle.class.getName(), this.onSuccess(id::complete));
        this.close((String)id.get(10L, TimeUnit.SECONDS), false);
    }

    @Test
    public void testUsingNonSharedInVerticle2() throws Exception {
        CompletableFuture id = new CompletableFuture();
        this.vertx.deployVerticle(NonSharedClientVerticle.class.getName(), new DeploymentOptions().setInstances(2), this.onSuccess(id::complete));
        this.close((String)id.get(10L, TimeUnit.SECONDS), false);
    }

    @Test
    public void testUsingSharedInVerticle() throws Exception {
        CompletableFuture id = new CompletableFuture();
        this.vertx.deployVerticle(SharedClientVerticle.class.getName(), new DeploymentOptions().setInstances(1), this.onSuccess(id::complete));
        this.close((String)id.get(10L, TimeUnit.SECONDS), false);
    }

    @Test
    public void testUsingSharedInVerticle2() throws Exception {
        CompletableFuture id = new CompletableFuture();
        this.vertx.deployVerticle(SharedClientVerticle.class.getName(), new DeploymentOptions().setInstances(2), this.onSuccess(id::complete));
        this.close((String)id.get(10L, TimeUnit.SECONDS), false);
    }

    @Test
    public void testUsingProvidedDataSourceVerticle() throws Exception {
        C3P0DataSourceProvider provider = new C3P0DataSourceProvider();
        ds = provider.getDataSource(theConfig);
        CompletableFuture id = new CompletableFuture();
        this.vertx.deployVerticle(ProvidedDataSourceVerticle.class.getName(), new DeploymentOptions().setInstances(1), this.onSuccess(id::complete));
        try {
            this.close((String)id.get(10L, TimeUnit.SECONDS), true);
        }
        finally {
            provider.close(ds);
        }
    }

    private void close(String deploymentId, boolean expectedDsThreadStatus) throws Exception {
        List<Thread> getConnThread = this.findThreads(t -> t.getName().equals("vertx-jdbc-service-get-connection-thread"));
        this.assertTrue(getConnThread.size() > 0);
        List<Thread> poolThreads = this.findThreads(t -> t.getName().startsWith("C3P0PooledConnectionPoolManager"));
        this.assertTrue(poolThreads.size() > 0);
        CountDownLatch closeLatch = new CountDownLatch(1);
        this.vertx.undeploy(deploymentId, this.onSuccess(v -> closeLatch.countDown()));
        this.awaitLatch(closeLatch);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 10000L) {
            if (!getConnThread.get(0).isAlive() && poolThreads.stream().allMatch(t -> t.isAlive() == expectedDsThreadStatus)) {
                return;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        String msg = Stream.concat(Stream.of(getConnThread.get(0)), poolThreads.stream()).map(t -> t.getName() + ": state=" + t.getState().name() + "/alive=" + t.isAlive()).collect(Collectors.joining(", ", "Timeout waiting for end condition:", "."));
        this.fail(msg);
    }

    private List<Thread> findThreads(Predicate<Thread> predicate) {
        return Thread.getAllStackTraces().keySet().stream().filter(predicate).collect(Collectors.toList());
    }

    public static class ProvidedDataSourceVerticle
    extends AbstractVerticle {
        public void start(Promise<Void> f) throws Exception {
            JDBCClient client = JDBCClient.create((Vertx)this.vertx, (DataSource)ds);
            String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
            client.getConnection(ar1 -> {
                if (ar1.succeeded()) {
                    SQLConnection conn = (SQLConnection)ar1.result();
                    conn.query(sql, ar2 -> {
                        if (ar2.succeeded()) {
                            f.complete();
                        } else {
                            f.fail(ar2.cause());
                        }
                    });
                } else {
                    f.fail(ar1.cause());
                }
            });
        }
    }

    public static class SharedClientVerticle
    extends AbstractVerticle {
        public void start(Promise<Void> f) throws Exception {
            JDBCClient client = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)theConfig);
            String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
            client.getConnection(ar1 -> {
                if (ar1.succeeded()) {
                    SQLConnection conn = (SQLConnection)ar1.result();
                    conn.query(sql, ar2 -> {
                        if (ar2.succeeded()) {
                            f.complete();
                        } else {
                            f.fail(ar2.cause());
                        }
                    });
                } else {
                    f.fail(ar1.cause());
                }
            });
        }
    }

    public static class NonSharedClientVerticle
    extends AbstractVerticle {
        public void start(Promise<Void> f) throws Exception {
            JDBCClient client = JDBCClient.create((Vertx)this.vertx, (JsonObject)theConfig);
            String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
            client.getConnection(ar1 -> {
                if (ar1.succeeded()) {
                    SQLConnection conn = (SQLConnection)ar1.result();
                    conn.query(sql, ar2 -> {
                        if (ar2.succeeded()) {
                            f.complete();
                        } else {
                            f.fail(ar2.cause());
                        }
                    });
                } else {
                    f.fail(ar1.cause());
                }
            });
        }
    }
}

