/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.DBConfigs;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.sql.SQLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.Test;

public class JDBCBatchTest
extends JDBCClientTestBase {
    public static void proc() {
        System.out.println("Fake Proc called");
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)DBConfigs.h2(JDBCBatchTest.class));
    }

    @Test
    public void testBatchStatement() {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("drop table if exists t");
        sql.add("create table t (u UUID)");
        sql.add("insert into t (u) values (random_uuid())");
        this.connection().batch(sql, this.onSuccess(batchResult -> {
            this.assertNotNull(batchResult);
            this.assertEquals(3L, batchResult.size());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testBatchPreparedStatement() {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("drop table if exists t");
        sql.add("create table t (u BIGINT)");
        SQLConnection conn = this.connection();
        conn.batch(sql, this.onSuccess(batchResult -> {
            this.assertNotNull(batchResult);
            this.assertEquals(2L, batchResult.size());
            ArrayList<JsonArray> args = new ArrayList<JsonArray>();
            args.add(new JsonArray().add((Object)System.currentTimeMillis()));
            args.add(new JsonArray().add((Object)System.currentTimeMillis()));
            args.add(new JsonArray().add((Object)System.currentTimeMillis()));
            conn.batchWithParams("insert into t (u) values (?)", args, this.onSuccess(batchResult2 -> {
                this.assertNotNull(batchResult2);
                this.assertEquals(3L, batchResult2.size());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testBatchCallableStatement() {
        SQLConnection conn = this.connection();
        conn.batch(Arrays.asList("CREATE ALIAS println FOR \"io.vertx.ext.jdbc.JDBCBatchTest.proc\""), this.onSuccess(batchResult -> {
            this.assertNotNull(batchResult);
            this.assertEquals(1L, batchResult.size());
            conn.batchCallableWithParams("{ call println() }", Arrays.asList(new JsonArray(), new JsonArray(), new JsonArray()), Arrays.asList(new JsonArray(), new JsonArray(), new JsonArray()), this.onSuccess(batchResult2 -> {
                this.assertNotNull(batchResult2);
                this.assertEquals(3L, batchResult2.size());
                this.testComplete();
            }));
        }));
        this.await();
    }

    private SQLConnection connection() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }
}

