/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.DBConfigs;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.TransactionIsolation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.Test;

public class JDBCCustomTXIsolationTest
extends JDBCClientTestBase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)DBConfigs.h2(JDBCCustomTXIsolationTest.class));
    }

    @Test
    public void testGetSet() {
        SQLConnection conn = this.connection();
        conn.getTransactionIsolation(txIsolation -> {
            if (txIsolation.failed()) {
                this.fail(txIsolation.cause());
                return;
            }
            conn.setTransactionIsolation((TransactionIsolation)txIsolation.result(), res -> {
                if (res.failed()) {
                    this.fail(res.cause());
                }
                this.testComplete();
            });
        });
        this.await();
    }

    private SQLConnection connection() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }
}

