/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.jdbc.DBConfigs;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.sql.SQLClient;
import io.vertx.test.fakemetrics.FakePoolMetrics;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class JDBCPoolMetricsTest
extends JDBCClientTestBase {
    private String dataSourceName = UUID.randomUUID().toString();

    private SQLClient getClient() {
        if (this.client == null) {
            this.client = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)DBConfigs.hsqldb(JDBCPoolMetricsTest.class).put("max_pool_size", (Object)10), (String)this.dataSourceName);
        }
        return this.client;
    }

    private FakePoolMetrics getMetrics() {
        return (FakePoolMetrics)FakePoolMetrics.getPoolMetrics().get(this.dataSourceName);
    }

    protected VertxOptions getOptions() {
        MetricsOptions options = new MetricsOptions().setEnabled(true);
        options.setFactory(options1 -> new VertxMetrics(){

            public PoolMetrics<?> createPoolMetrics(String poolType, String poolName, int maxPoolSize) {
                if (poolType.equals("datasource")) {
                    JDBCPoolMetricsTest.this.assertEquals("datasource", poolType);
                    return new FakePoolMetrics(poolName, maxPoolSize);
                }
                return super.createPoolMetrics(poolType, poolName, maxPoolSize);
            }
        });
        return new VertxOptions().setMetricsOptions(options);
    }

    @Test
    public void testLifecycle() {
        Map metricsMap = FakePoolMetrics.getPoolMetrics();
        this.assertEquals(Collections.emptySet(), metricsMap.keySet());
        this.client = this.getClient();
        this.assertEquals(0L, metricsMap.size());
        this.client.getConnection(this.onSuccess(conn -> {
            this.assertEquals(1L, metricsMap.size());
            this.assertEquals(10L, this.getMetrics().getPoolSize());
            conn.close(this.onSuccess(connClosed -> this.client.close(this.onSuccess(clientClose -> {
                this.assertEquals(0L, metricsMap.size());
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testUseConnection() {
        this.client = this.getClient();
        this.client.getConnection(this.onSuccess(conn -> {
            this.assertEquals(0L, this.getMetrics().numberOfWaitingTasks());
            this.assertEquals(1L, this.getMetrics().numberOfRunningTasks());
            conn.close(this.onSuccess(v -> {
                this.assertEquals(0L, this.getMetrics().numberOfWaitingTasks());
                this.assertEquals(0L, this.getMetrics().numberOfRunningTasks());
                conn.close(ar -> {
                    this.assertEquals(0L, this.getMetrics().numberOfWaitingTasks());
                    this.assertEquals(0L, this.getMetrics().numberOfRunningTasks());
                    this.testComplete();
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testQueue() throws Exception {
        this.client = this.getClient();
        CompletableFuture<Object> close = new CompletableFuture<Object>();
        AtomicInteger closedCount = new AtomicInteger();
        CountDownLatch closedLatch = new CountDownLatch(11);
        CountDownLatch connectedLatch = new CountDownLatch(10);
        for (int i = 0; i < 11; ++i) {
            this.client.getConnection(this.onSuccess(conn -> {
                connectedLatch.countDown();
                close.thenAccept(v -> conn.close(ar -> {
                    closedCount.decrementAndGet();
                    closedLatch.countDown();
                }));
            }));
        }
        this.awaitLatch(connectedLatch);
        this.assertEquals(10L, this.getMetrics().numberOfRunningTasks());
        this.assertEquals(1L, this.getMetrics().numberOfWaitingTasks());
        close.complete(null);
        this.awaitLatch(closedLatch);
        this.assertEquals(0L, this.getMetrics().numberOfWaitingTasks());
        this.assertEquals(0L, this.getMetrics().numberOfRunningTasks());
    }
}

