/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.DBConfigs;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.sql.SQLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JDBCStoredProcedureTest
extends JDBCClientTestBase {
    private static final List<String> SQL = new ArrayList<String>();

    @BeforeClass
    public static void createDb() throws Exception {
        Connection conn = DriverManager.getConnection(DBConfigs.hsqldb(JDBCStoredProcedureTest.class).getString("url"));
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)DBConfigs.hsqldb(JDBCStoredProcedureTest.class));
    }

    @Test
    public void testStoredProcedure0() {
        this.connection().callWithParams("{call new_customer(?, ?)}", new JsonArray().add((Object)"Paulo").add((Object)"Lopes"), null, this.onSuccess(resultSet -> this.testComplete()));
        this.await();
    }

    @Test
    public void testStoredProcedure1() {
        this.connection().callWithParams("{call customer_lastname(?, ?)}", new JsonArray().add((Object)"Paulo"), new JsonArray().addNull().add((Object)"VARCHAR"), this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(0L, resultSet.getResults().size());
            this.assertEquals("Lopes", resultSet.getOutput().getString(1));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStoredProcedure2() {
        this.connection().callWithParams("{call an_hour_before()}", null, null, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStoredProcedure3() {
        this.connection().callWithParams("{call times2(?)}", new JsonArray().add((Object)2), new JsonArray().add((Object)"INTEGER"), this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(0L, resultSet.getResults().size());
            this.assertEquals(new Integer(4), resultSet.getOutput().getInteger(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStoredProcedure4() {
        this.client.callWithParams("{call times2(?)}", new JsonArray().add((Object)2), new JsonArray().add((Object)"INTEGER"), this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(0L, resultSet.getResults().size());
            this.assertEquals(new Integer(4), resultSet.getOutput().getInteger(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStoredProcedure5() {
        this.client.callWithParams("{call time__s2(?)}", new JsonArray().add((Object)2), new JsonArray().add((Object)"INTEGER"), this.onFailure(t -> this.testComplete()));
        this.await();
    }

    @Test
    public void testStoredProcedure6() {
        this.client.callWithParams("{call an_hour_before()}", null, null, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStoredProcedure7() {
        this.client.callWithParams("{call an_hour_____before()}", null, null, this.onFailure(t -> this.testComplete()));
        this.await();
    }

    @Test
    public void testReturnIds() {
        this.connection().update("insert into customers(firstname, lastname) values('Paulo', 'Lopes')", this.onSuccess(updateResult -> {
            this.assertNotNull(updateResult);
            this.assertNotNull(updateResult.getKeys());
            this.assertTrue(updateResult.getKeys().size() > 0);
            this.testComplete();
        }));
        this.await();
    }

    private SQLConnection connection() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }

    static {
        System.setProperty("textdb.allow_full_path", "true");
        System.setProperty("statement.separator", ";;");
        SQL.add("drop table if exists customers");
        SQL.add("create table customers(id integer generated by default as identity, firstname varchar(50), lastname varchar(50), added timestamp)");
        SQL.add("create procedure new_customer(firstname varchar(50), lastname varchar(50))\n  modifies sql data\n  insert into customers values (default, firstname, lastname, current_timestamp)");
        SQL.add("create procedure customer_lastname(IN firstname varchar(50), OUT lastname varchar(50))\n  modifies sql data\n  select lastname into lastname from customers where firstname = firstname");
        SQL.add("create function an_hour_before()\n  returns timestamp\n  return now() - 1 hour");
        SQL.add("create procedure times2(INOUT param INT)\n  modifies sql data\n  SET param = param * 2");
    }
}

