/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Tuple;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OracleTest {
    @Rule
    public final RunTestOnContext rule = new RunTestOnContext();

    @Test
    @Ignore(value="Cannot run this in CI as we can't install Oracle")
    public void testSimple(TestContext should) {
        Async test = should.async();
        JDBCPool pool = JDBCPool.pool((Vertx)this.rule.vertx(), (JDBCConnectOptions)new JDBCConnectOptions().setJdbcUrl("jdbc:oracle:thin:@127.0.0.1:1521:xe").setUser("sys as sysdba").setPassword("vertx"), (PoolOptions)new PoolOptions());
        pool.preparedQuery("DELETE FROM product WHERE id = ?").execute(Tuple.of((Object)"missing-id")).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rowSet -> test.complete());
    }

    @Test
    @Ignore(value="Cannot run this in CI as we can't install Oracle")
    public void testBlocking(TestContext should) {
        Async test = should.async();
        JDBCPool pool = JDBCPool.pool((Vertx)this.rule.vertx(), (JDBCConnectOptions)new JDBCConnectOptions().setJdbcUrl("jdbc:oracle:thin:@127.0.0.1:1521:xe").setUser("sys as sysdba").setPassword("vertx"), (PoolOptions)new PoolOptions());
        pool.preparedQuery("SELECT TEST_SLEEP(10.5) FROM DUAL").execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rowSet -> test.complete());
    }

    @Test
    @Ignore
    public void slowDecode(TestContext should) {
        Async test = should.async();
        JDBCPool pool = JDBCPool.pool((Vertx)this.rule.vertx(), (JDBCConnectOptions)new JDBCConnectOptions().setJdbcUrl("jdbc:oracle:thin:@127.0.0.1:1521:xe").setUser("sys as sysdba").setPassword("vertx"), (PoolOptions)new PoolOptions());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 30000; ++i) {
            sb.append('a');
        }
        Runnable queryIt = () -> {
            long start = System.currentTimeMillis();
            pool.preparedQuery("select * FROM CONFIG").execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rowSet -> {
                long end = System.currentTimeMillis();
                System.out.println(end - start);
                test.complete();
            });
        };
        queryIt.run();
    }
}

