/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.DBConfigs;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.sql.SQLClient;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.BeforeClass;
import org.junit.Test;

public class SharedClientTest
extends JDBCClientTestBase {
    @BeforeClass
    public static void createDb() throws Exception {
        SharedClientTest.resetDb(SharedClientTest.class);
    }

    @Test(timeout=60000L)
    public void testDeadlock() throws Exception {
        final JsonObject config = DBConfigs.hsqldb(SharedClientTest.class);
        int num = 6;
        final int iter = 5000;
        final AtomicInteger count = new AtomicInteger();
        ArrayList<1> threads = new ArrayList<1>();
        for (int i = 0; i < num; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < iter; ++i) {
                        count.incrementAndGet();
                        JDBCClient client = JDBCClient.createShared((Vertx)SharedClientTest.this.vertx, (JsonObject)config);
                        JDBCClientTestBase.close((SQLClient)client);
                    }
                }
            };
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }
}

