/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.spi.impl.JDBCEncoderImpl;
import io.vertx.jdbcclient.impl.actions.JDBCColumnDescriptor;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JDBCDecoderTest {
    private JDBCStatementHelper helper = new JDBCStatementHelper();
    private String value;
    private Object expectedSqlValue;
    private Class<?> expectedSqlType;
    private JDBCType jdbcType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> generateData() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ZonedDateTime dateTime = ZonedDateTime.of(2016, 3, 16, 16, 0, 0, 0, ZoneId.of("Europe/Paris"));
        for (int i = 0; i < 4; ++i) {
            int nanos = 123 * (i == 0 ? 0 : 1) * (int)Math.pow(1000.0, i > 1 ? (double)(i - 1) : 0.0);
            params.add(new Object[]{DateTimeFormatter.ISO_INSTANT.format(dateTime.withNano(nanos)), dateTime.withNano(nanos).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC), OffsetDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE});
        }
        params.add(new Object[]{DateTimeFormatter.ISO_LOCAL_TIME.format(dateTime.withSecond(1)), dateTime.withSecond(1).toLocalTime(), LocalTime.class, JDBCType.TIME});
        params.add(new Object[]{dateTime.toLocalDate().toString(), dateTime.toLocalDate(), LocalDate.class, JDBCType.DATE});
        params.add(new Object[]{"f47ac10b-58cc-4372-a567-0e02b2c3d479", UUID.fromString("f47ac10b-58cc-4372-a567-0e02b2c3d479"), UUID.class, JDBCType.BINARY});
        return params;
    }

    public JDBCDecoderTest(String value, Object expectedSqlValue, Class<?> expectedSqlType, JDBCType jdbcType) {
        this.value = value;
        this.expectedSqlValue = expectedSqlValue;
        this.expectedSqlType = expectedSqlType;
        this.jdbcType = jdbcType;
    }

    @Test
    public void testSQLConvert() throws SQLException {
        Object cast = ((JDBCEncoderImpl)this.helper.getEncoder()).doEncode(JDBCColumnDescriptor.wrap((JDBCType)this.jdbcType), (Object)this.value);
        MatcherAssert.assertThat((Object)cast, (Matcher)CoreMatchers.instanceOf(this.expectedSqlType));
        Object convert = this.helper.getDecoder().cast(cast);
        Assert.assertEquals((Object)this.expectedSqlValue, (Object)convert);
    }
}

