/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql.test;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResultSetTest {
    protected List<String> columnNames;
    protected List<JsonArray> results;
    protected ResultSet rs;
    protected int numRows = 10;

    @Before
    public void before() {
        this.columnNames = Arrays.asList("foo", "bar", "wibble");
        this.results = new ArrayList<JsonArray>();
        int numRows = 10;
        for (int i = 0; i < numRows; ++i) {
            JsonArray result = new JsonArray();
            for (int j = 0; j < this.columnNames.size(); ++j) {
                result.add((Object)("res" + j));
            }
            this.results.add(result);
        }
        this.rs = new ResultSet(this.columnNames, this.results, null);
    }

    @Test
    public void testResultSet() {
        Assert.assertEquals((long)this.numRows, (long)this.rs.getNumRows());
        Assert.assertEquals((long)this.columnNames.size(), (long)this.rs.getNumColumns());
        Assert.assertEquals((long)this.columnNames.size(), (long)this.rs.getColumnNames().size());
        Assert.assertEquals(this.columnNames, (Object)this.rs.getColumnNames());
        Assert.assertEquals(this.results, (Object)this.rs.getResults());
        List rows = this.rs.getRows();
        Assert.assertEquals((long)this.numRows, (long)this.rs.getRows().size());
        int index = 0;
        for (JsonObject row : rows) {
            JsonArray result = this.results.get(index);
            Assert.assertEquals((long)this.columnNames.size(), (long)row.size());
            Assert.assertEquals((long)row.size(), (long)result.size());
            for (int i = 0; i < this.columnNames.size(); ++i) {
                String columnName = this.columnNames.get(i);
                String columnValue = result.getString(i);
                Assert.assertEquals((Object)columnValue, (Object)row.getString(columnName));
            }
            ++index;
        }
    }

    @Test
    public void testCaseInsensitiveRows() {
        JsonObject row = (JsonObject)this.rs.getRows(true).get(0);
        Assert.assertEquals((Object)"res0", (Object)row.getString("foo"));
        Assert.assertEquals((Object)"res0", (Object)row.getString("FOO"));
        Assert.assertEquals((Object)"res0", (Object)row.getString("fOo"));
    }

    @Test
    public void testJson() {
        JsonObject json = this.rs.toJson();
        ResultSet rs2 = new ResultSet(json);
        Assert.assertEquals((Object)this.rs, (Object)rs2);
    }
}

