/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.testcontainers.containers.ClickHouseContainer;

@RunWith(value=VertxUnitRunner.class)
public class ClickHouseOldAPITest {
    private Vertx vertx;
    private ClickHouseContainer container;
    protected JDBCClient client;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.container = new ClickHouseContainer("yandex/clickhouse-server:20.8");
        this.container.withInitScript("init-clickhouse.sql");
        this.container.start();
        JsonObject config = new JsonObject().put("driver_class", (Object)"ru.yandex.clickhouse.ClickHouseDriver").put("url", (Object)("jdbc:clickhouse://localhost:" + this.container.getMappedPort(8123) + "/default"));
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)config);
    }

    @After
    public void after(TestContext should) {
        Async cleanup = should.async();
        this.client.close(should.asyncAssertSuccess(res1 -> this.vertx.close(should.asyncAssertSuccess(res2 -> {
            this.container.close();
            cleanup.complete();
        }))));
    }

    @Test
    public void simpleTest(TestContext should) {
        Async test = should.async();
        this.client.query("select * from arr_test", should.asyncAssertSuccess(res -> {
            should.assertEquals((Object)1, (Object)res.getNumRows());
            JsonObject row = (JsonObject)res.getRows().get(0);
            should.assertEquals((Object)new JsonObject().put("id", (Object)"1ff954bb-9808-4309-9955-fccf1a26266e").put("value", (Object)new JsonArray().add((Object)0.0).add((Object)1.0)).encode(), (Object)row.encode());
            test.complete();
        }));
    }
}

