/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.it.MSSQLDecoder;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.jdbcclient.SqlOutParam;
import io.vertx.jdbcclient.impl.AgroalCPDataSourceProvider;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.testcontainers.containers.MSSQLServerContainer;

@RunWith(value=VertxUnitRunner.class)
public class MSSQLTest {
    @ClassRule
    public static final RunTestOnContext rule = new RunTestOnContext();
    private static MSSQLServer server;

    @BeforeClass
    public static void setup(TestContext should) {
        Async test = should.async();
        rule.vertx().executeBlocking(p -> {
            try {
                server = new MSSQLServer();
                server.withInitScript("init-mssql.sql");
                server.start();
                p.complete();
            }
            catch (RuntimeException e) {
                p.fail((Throwable)e);
            }
        }, true).onSuccess(o -> test.complete()).onFailure(arg_0 -> ((TestContext)should).fail(arg_0));
    }

    @AfterClass
    public static void tearDown() {
        server.close();
    }

    protected JDBCPool initJDBCPool() {
        return this.initJDBCPool(new JsonObject());
    }

    protected JDBCPool initJDBCPool(JsonObject extraOption) {
        JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl(server.getJdbcUrl()).setUser(server.getUsername()).setPassword(server.getPassword());
        AgroalCPDataSourceProvider provider = new AgroalCPDataSourceProvider(options, new PoolOptions().setMaxSize(1));
        return JDBCPool.pool((Vertx)rule.vertx(), (DataSourceProvider)provider.init(extraOption));
    }

    protected JDBCClient initJDBCClient(JsonObject extraOption) {
        JsonObject options = new JsonObject().put("url", (Object)server.getJdbcUrl()).put("user", (Object)server.getUsername()).put("password", (Object)server.getPassword());
        return JDBCClient.createShared((Vertx)rule.vertx(), (JsonObject)options.mergeIn(extraOption, true), (String)"dbName");
    }

    @Test
    public void simpleTest(TestContext should) {
        Async test = should.async();
        JDBCPool client = this.initJDBCPool();
        client.preparedQuery("select * from Fortune").execute(should.asyncAssertSuccess(resultSet -> {
            should.assertEquals((Object)12, (Object)resultSet.size());
            test.complete();
        }));
    }

    @Test
    public void simpleRSAfterUpdate(TestContext should) {
        Async test = should.async();
        JDBCPool client = this.initJDBCPool();
        client.preparedQuery("INSERT INTO test (field1)\nSELECT ?").executeBatch((List)new ArrayList<Tuple>(){
            {
                Tuple.of((Object)1);
            }
        }).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rowSet -> test.complete());
    }

    @Test
    public void testProcedures(TestContext should) {
        Async test = should.async();
        JDBCPool client = this.initJDBCPool();
        client.preparedQuery("{ call rsp_vertx_test_1(?, ?)}").execute(Tuple.of((Object)1, (Object)SqlOutParam.OUT((JDBCType)JDBCType.VARCHAR))).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertTrue(rows.size() > 0);
            for (Row row : rows) {
                should.assertNotNull((Object)row);
            }
            rows = rows.next();
            should.assertNotNull(rows);
            should.assertTrue(((Boolean)rows.property(JDBCPool.OUTPUT)).booleanValue());
            should.assertTrue(rows.size() > 0);
            for (Row row : rows) {
                should.assertEquals((Object)"echo", (Object)row.getString(0));
            }
            test.complete();
        });
    }

    @Test
    public void testProcedures2(TestContext should) {
        Async test = should.async();
        JDBCPool client = this.initJDBCPool();
        client.preparedQuery("{ call rsp_vertx_test_2(?)}").execute(Tuple.of((Object)SqlOutParam.OUT((JDBCType)JDBCType.VARCHAR))).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertTrue(((Boolean)rows.property(JDBCPool.OUTPUT)).booleanValue());
            should.assertTrue(rows.size() > 0);
            for (Row row : rows) {
                should.assertEquals((Object)"echo", (Object)row.getString(0));
                should.assertEquals((Object)"echo", (Object)row.getString("0"));
            }
            test.complete();
        });
    }

    @Test
    public void testQueryWithJDBCPool(TestContext should) {
        Async async = should.async();
        JDBCPool client = this.initJDBCPool();
        client.query("SELECT * FROM special_datatype").execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)1, (Object)rows.size());
            should.assertTrue(rows.columnsNames().containsAll(Arrays.asList("id", "dto")));
            Row row = (Row)rows.iterator().next();
            should.assertEquals((Object)1, (Object)row.getInteger(0));
            should.assertEquals((Object)"2020-12-12 19:30:30.12345 +00:00", (Object)row.getString(1));
            should.assertEquals((Object)1, (Object)row.getInteger("id"));
            should.assertEquals((Object)"2020-12-12 19:30:30.12345 +00:00", (Object)row.getString("dto"));
            async.complete();
        });
    }

    @Test
    public void testQueryWithJDBCPoolHasMSSQLDecoder(TestContext should) {
        Async async = should.async();
        JDBCPool client = this.initJDBCPool(new JsonObject().put("decoderCls", (Object)MSSQLDecoder.class.getName()));
        client.query("SELECT * FROM special_datatype").execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)1, (Object)rows.size());
            should.assertTrue(rows.columnsNames().containsAll(Arrays.asList("id", "dto")));
            Row row = (Row)rows.iterator().next();
            should.assertEquals((Object)1, (Object)row.getInteger(0));
            OffsetDateTime expected = OffsetDateTime.of(LocalDate.of(2020, 12, 12), LocalTime.of(19, 30, 30, 123450000), ZoneOffset.UTC);
            should.assertEquals((Object)expected, row.getValue(1));
            async.complete();
        });
    }

    @Test
    public void testQueryWithJDBCClientHasMSSQLDecoder(TestContext should) {
        Async async = should.async();
        JDBCClient client = this.initJDBCClient(new JsonObject().put("decoderCls", (Object)MSSQLDecoder.class.getName()));
        client.query("SELECT * FROM special_datatype", should.asyncAssertSuccess(resultSet -> {
            Assert.assertEquals((long)1L, (long)resultSet.getNumRows());
            JsonArray row = (JsonArray)resultSet.getResults().get(0);
            Assert.assertEquals((long)1L, (long)row.getInteger(0).intValue());
            Object dto = row.getValue(1);
            OffsetDateTime expected = OffsetDateTime.of(LocalDate.of(2020, 12, 12), LocalTime.of(19, 30, 30, 123450000), ZoneOffset.UTC);
            Assert.assertEquals(OffsetDateTime.class, dto.getClass());
            Assert.assertEquals((Object)expected, (Object)dto);
            async.complete();
        }));
    }

    static class MSSQLServer
    extends MSSQLServerContainer {
        MSSQLServer() {
        }

        protected void configure() {
            this.addExposedPort(MSSQLServerContainer.MS_SQL_SERVER_PORT);
            this.addEnv("ACCEPT_EULA", "Y");
            this.addEnv("SA_PASSWORD", this.getPassword());
        }
    }
}

