/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.testcontainers.containers.OracleContainer;

@RunWith(value=VertxUnitRunner.class)
@Ignore(value="This container doesn't start on GitHub")
public class OracleTest {
    @ClassRule
    public static final RunTestOnContext rule = new RunTestOnContext();
    @ClassRule
    public static final OracleContainer server = (OracleContainer)new OracleContainer("wnameless/oracle-xe-11g-r2:latest").withInitScript("init-oracle.sql");

    @Test
    public void simpleDeleteTest(TestContext should) {
        Async test = should.async();
        JDBCClient client = this.initJDBCClient();
        client.updateWithParams("DELETE FROM insert_table WHERE id = ?", new JsonArray().add((Object)1), should.asyncAssertSuccess(resultSet -> {
            should.assertEquals((Object)1, (Object)resultSet.getUpdated());
            test.complete();
        }));
    }

    @Test
    public void simpleSelectTest(TestContext should) {
        Async async = should.async();
        JDBCClient client = this.initJDBCClient();
        client.query("SELECT * FROM insert_table WHERE id = 2", should.asyncAssertSuccess(resultSet -> {
            Assert.assertEquals((long)1L, (long)resultSet.getNumRows());
            JsonArray row = (JsonArray)resultSet.getResults().get(0);
            Assert.assertEquals((long)2L, (long)row.getInteger(0).intValue());
            Assert.assertEquals((Object)"hello", (Object)row.getValue(1));
            Assert.assertEquals((Object)"vertx", (Object)row.getValue(2));
            Assert.assertEquals(LocalDateTime.class, row.getValue(3).getClass());
            Assert.assertEquals(LocalDateTime.class, row.getValue(4).getClass());
            async.complete();
        }));
    }

    @Test
    public void simpleInsertTest(TestContext should) {
        Async async = should.async();
        JDBCClient client = this.initJDBCClient();
        client.updateWithParams("INSERT INTO insert_table VALUES (?, ?, ?, ?, ?)", new JsonArray().add((Object)3).add((Object)"doe").add((Object)"john").add((Object)LocalDateTime.of(2001, 1, 1, 0, 0)).add((Object)LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault())), should.asyncAssertSuccess(resultSet -> {
            Assert.assertEquals((long)1L, (long)resultSet.getUpdated());
            async.complete();
        }));
    }

    @Test
    public void simpleUpdateTest(TestContext should) {
        Async async = should.async();
        JDBCClient client = this.initJDBCClient();
        client.updateWithParams("UPDATE insert_table SET lname=?, cdate=? WHERE id = 2", new JsonArray().add((Object)"aName").add((Object)LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault())), should.asyncAssertSuccess(resultSet -> {
            should.assertEquals((Object)1, (Object)resultSet.getUpdated());
            async.complete();
        }));
    }

    private JDBCClient initJDBCClient() {
        JsonObject options = new JsonObject().put("url", (Object)server.getJdbcUrl()).put("user", (Object)server.getUsername()).put("password", (Object)server.getPassword()).put("driver_class", (Object)"oracle.jdbc.driver.OracleDriver");
        return JDBCClient.createShared((Vertx)rule.vertx(), (JsonObject)options, (String)"dbName");
    }
}

