/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.jdbcclient.SqlOutParam;
import io.vertx.jdbcclient.impl.AgroalCPDataSourceProvider;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.Tuple;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.List;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.postgresql.util.PGInterval;
import org.testcontainers.containers.PostgreSQLContainer;

@RunWith(value=VertxUnitRunner.class)
public class PostgresTest {
    @ClassRule
    public static final RunTestOnContext rule = new RunTestOnContext();
    @ClassRule
    public static final PostgreSQLContainer server = (PostgreSQLContainer)new PostgreSQLContainer("postgres:12-alpine").withInitScript("init-pgsql.sql");

    protected JDBCPool initJDBCPool(JsonObject extraOption) {
        JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl(server.getJdbcUrl()).setUser(server.getUsername()).setPassword(server.getPassword());
        AgroalCPDataSourceProvider provider = new AgroalCPDataSourceProvider(options, new PoolOptions().setMaxSize(1));
        return JDBCPool.pool((Vertx)rule.vertx(), (DataSourceProvider)provider.init(extraOption));
    }

    protected JDBCClient initJDBCClient(JsonObject extraOption) {
        JsonObject options = new JsonObject().put("url", (Object)server.getJdbcUrl()).put("user", (Object)server.getUsername()).put("password", (Object)server.getPassword());
        return JDBCClient.createShared((Vertx)rule.vertx(), (JsonObject)options.mergeIn(extraOption, true), (String)"dbName");
    }

    @Test
    public void simpleClientCallFunctionTest(TestContext should) {
        Async test = should.async();
        JDBCClient client = this.initJDBCClient(new JsonObject());
        client.callWithParams("{ call animal_stats(?, ?, ?) }", new JsonArray().add((Object)false), new JsonArray().addNull().add((Object)"BIGINT").add((Object)"REAL"), asyncResult -> {
            if (asyncResult.failed()) {
                should.fail(asyncResult.cause());
            } else {
                ResultSet statsResult = (ResultSet)asyncResult.result();
                JsonArray output = statsResult.getOutput();
                System.out.println(new JsonObject().put("stats", (Object)output.toString()).encodePrettily());
                should.assertTrue(output.getValue(1) instanceof Number);
                should.assertTrue(output.getValue(2) instanceof Number);
                test.complete();
            }
        });
    }

    @Test
    public void simplePoolCallFunctionTest(TestContext should) {
        Async test = should.async();
        JDBCPool pool = this.initJDBCPool(new JsonObject());
        pool.preparedQuery("{ call animal_stats(?, ?, ?) }").execute(Tuple.of((Object)false, (Object)SqlOutParam.OUT((JDBCType)JDBCType.BIGINT), (Object)SqlOutParam.OUT((JDBCType)JDBCType.REAL))).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            if (((Boolean)rows.property(JDBCPool.OUTPUT)).booleanValue()) {
                for (Row row : rows) {
                    should.assertTrue(row.getValue(0) instanceof Number);
                    should.assertEquals((Object)3, (Object)row.getInteger(0));
                    should.assertTrue(row.getValue(1) instanceof Number);
                    should.assertEquals((Object)33.33333206176758, (Object)row.getDouble(1));
                }
            }
            test.complete();
        });
    }

    @Test
    public void simplePoolSelectFunctionTest(TestContext should) {
        Async test = should.async();
        JDBCPool pool = this.initJDBCPool(new JsonObject());
        pool.preparedQuery("select * from animal_stats(?)").execute(Tuple.of((Object)false)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            for (Row row : rows) {
                should.assertTrue(row.getValue(0) instanceof Number);
                should.assertEquals((Object)3, (Object)row.getInteger(0));
                should.assertTrue(row.getValue(1) instanceof Number);
                should.assertEquals((Object)33.33333206176758, (Object)row.getDouble(1));
            }
            test.complete();
        });
    }

    @Test
    public void simpleRowStreamTest(TestContext should) {
        Async test = should.async();
        JDBCPool pool = this.initJDBCPool(new JsonObject());
        List<String> animals = Arrays.asList("dog", "cat", "cow");
        pool.getConnection().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(connection -> connection.prepare("SELECT * FROM ANIMAL").onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(pq -> connection.begin().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(tx -> {
            RowStream stream = pq.createStream(1);
            stream.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            stream.endHandler(v -> stream.close(closed -> tx.commit(committed -> test.complete())));
            stream.handler(row -> should.assertTrue(animals.contains(row.getString("name"))));
        })));
    }

    @Test
    public void threeParamsTest(TestContext should) {
        Async test = should.async();
        JDBCClient client = this.initJDBCClient(new JsonObject());
        this.callWithInOut(client, "{ call f_inout_inout_inout(?, ?, ?) }", new JsonArray().add((Object)false).add((Object)false).add((Object)false), new JsonArray().add((Object)"BOOLEAN").add((Object)"BOOLEAN").add((Object)"BOOLEAN")).compose(v -> this.callWithInOut(client, "{ call f_in_inout_inout(?, ?, ?) }", new JsonArray().add((Object)false).add((Object)false).add((Object)false), new JsonArray().addNull().add((Object)"BOOLEAN").add((Object)"BOOLEAN"))).compose(v -> this.callWithInOut(client, "{ call f_blank_inout_inout(?, ?, ?) }", new JsonArray().add((Object)false).add((Object)false).add((Object)false), new JsonArray().addNull().add((Object)"BOOLEAN").add((Object)"BOOLEAN"))).compose(v -> this.callWithInOut(client, "{ call f_in_out_out(?, ?, ?) }", new JsonArray().add((Object)false), new JsonArray().addNull().add((Object)"BOOLEAN").add((Object)"BOOLEAN"))).compose(v -> this.callWithInOut(client, "{ call f_blank_out_out(?, ?, ?) }", new JsonArray(), new JsonArray().addNull().add((Object)"BOOLEAN").add((Object)"BOOLEAN"))).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(v -> test.complete());
    }

    private Future<Void> callWithInOut(JDBCClient client, String sql, JsonArray in, JsonArray out) {
        PromiseInternal promise = ((VertxInternal)rule.vertx()).promise();
        client.callWithParams(sql, in, out, arg_0 -> this.lambda$callWithInOut$15(sql, in, out, (Promise)promise, arg_0));
        return promise.future();
    }

    private void printResults(String succMsg, String sql, JsonArray in, JsonArray out, String result) {
        System.out.println(succMsg + " sql: " + sql + " \n IN: " + in.toString() + "\n OUT: " + out.toString() + "\n result: " + result);
    }

    @Test
    public void testQueryTemporalTable(TestContext should) {
        Async async = should.async();
        JDBCClient client = this.initJDBCClient(new JsonObject());
        client.query("SELECT * FROM temporal_data_type WHERE id = 1", should.asyncAssertSuccess(resultSet -> {
            should.assertEquals((Object)1, (Object)resultSet.getNumRows());
            JsonArray row = (JsonArray)resultSet.getResults().get(0);
            should.assertEquals((Object)1, (Object)row.getInteger(0));
            should.assertEquals((Object)LocalDate.parse("2022-05-30"), row.getValue(1));
            should.assertEquals((Object)LocalTime.parse("18:00:00"), row.getValue(2));
            should.assertEquals((Object)OffsetTime.parse("04:00:00Z"), row.getValue(3));
            should.assertEquals((Object)LocalDateTime.parse("2022-05-14T07:00:00"), row.getValue(4));
            should.assertEquals((Object)OffsetDateTime.parse("2022-05-14T09:00:00Z"), row.getValue(5));
            should.assertEquals((Object)"10 years 3 mons 332 days 20 hours 20 mins 20.999999 secs", row.getValue(6));
            async.complete();
        }));
    }

    @Test
    public void testPoolQueryTemporalTable(TestContext should) {
        Async async = should.async();
        JDBCPool pool = this.initJDBCPool(new JsonObject());
        pool.preparedQuery("SELECT * FROM temporal_data_type WHERE id = 1").execute().onSuccess(rows -> {
            should.assertEquals((Object)1, (Object)((RowSet)rows.value()).size());
            Row row = (Row)((RowSet)rows.value()).iterator().next();
            should.assertEquals((Object)1, (Object)row.getInteger(0));
            should.assertEquals((Object)LocalDate.parse("2022-05-30"), row.getValue(1));
            should.assertEquals((Object)LocalTime.parse("18:00:00"), row.getValue(2));
            should.assertEquals((Object)OffsetTime.parse("04:00:00Z"), row.getValue(3));
            should.assertEquals((Object)LocalDateTime.parse("2022-05-14T07:00:00"), row.getValue(4));
            should.assertEquals((Object)OffsetDateTime.parse("2022-05-14T09:00:00Z"), row.getValue(5));
            should.assertEquals((Object)"10 years 3 mons 332 days 20 hours 20 mins 20.999999 secs", row.getValue(6));
            async.complete();
        }).onFailure(arg_0 -> ((TestContext)should).fail(arg_0));
    }

    @Test
    public void testInsertTemporalTable(TestContext should) throws SQLException {
        Async async = should.strictAsync(2);
        JDBCPool pool = this.initJDBCPool(new JsonObject());
        Tuple params = Tuple.tuple().addValue((Object)2).addValue((Object)LocalDate.parse("2022-05-30")).addValue((Object)LocalTime.parse("18:00:00")).addValue((Object)OffsetTime.parse("06:00:00+02:00")).addValue((Object)LocalDateTime.parse("2022-05-14T07:00:00")).addValue((Object)OffsetDateTime.parse("2022-05-14T07:00:00-02:00")).addValue((Object)new PGInterval("10 years 3 mons 332 days 20 hours 20 mins 20.999999 secs"));
        pool.preparedQuery("INSERT INTO temporal_data_type(\"id\", \"Date\", \"Time\", \"TimeTz\", \"Timestamp\", \"TimestampTz\", \"Interval\") VALUES (?, ?, ?, ?, ?, ?, ?)").execute(params).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> async.countDown()).flatMap(ignore -> pool.preparedQuery("SELECT * FROM temporal_data_type WHERE id = 2").execute()).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            Row row = (Row)((RowSet)rows.value()).iterator().next();
            should.assertEquals((Object)2, (Object)row.getInteger(0));
            should.assertEquals((Object)LocalDate.parse("2022-05-30"), row.getValue(1));
            should.assertEquals((Object)LocalTime.parse("18:00:00"), row.getValue(2));
            should.assertEquals((Object)OffsetTime.parse("04:00:00Z"), row.getValue(3));
            should.assertEquals((Object)LocalDateTime.parse("2022-05-14T07:00:00"), row.getValue(4));
            should.assertEquals((Object)OffsetDateTime.parse("2022-05-14T09:00:00Z"), row.getValue(5));
            should.assertEquals((Object)"10 years 3 mons 332 days 20 hours 20 mins 20.999999 secs", row.getValue(6));
            async.complete();
        });
    }

    private /* synthetic */ void lambda$callWithInOut$15(String sql, JsonArray in, JsonArray out, Promise promise, AsyncResult asyncResult) {
        if (asyncResult.failed()) {
            this.printResults("FAIL ", sql, in, out, asyncResult.cause().getMessage());
            promise.fail(asyncResult.cause());
        } else {
            ResultSet statsResult = (ResultSet)asyncResult.result();
            JsonArray output = statsResult.getOutput();
            this.printResults("OK   ", sql, in, out, output.encodePrettily());
            promise.complete();
        }
    }
}

