/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ClientTest
extends ClientTestBase {
    protected SqlConnection connection() throws Exception {
        return (SqlConnection)this.client.getConnection().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
    }

    @Test
    public void testConnectionSelect(TestContext ctx) throws Exception {
        this.testSelect(ctx, (SqlClient)this.connection());
    }

    @Test
    public void testClientSelect(TestContext ctx) throws Exception {
        this.testSelect(ctx, (SqlClient)this.client);
    }

    private void testSelect(TestContext ctx, SqlClient client) throws Exception {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        client.query(sql).execute(ctx.asyncAssertSuccess(resultSet -> {
            ctx.assertEquals((Object)2, (Object)resultSet.size());
            ctx.assertEquals((Object)"ID", resultSet.columnsNames().get(0));
            ctx.assertEquals((Object)"FNAME", resultSet.columnsNames().get(1));
            ctx.assertEquals((Object)"LNAME", resultSet.columnsNames().get(2));
            RowIterator it = resultSet.iterator();
            Row result0 = (Row)it.next();
            ctx.assertEquals((Object)1, (Object)result0.getInteger(0));
            ctx.assertEquals((Object)"john", (Object)result0.getString(1));
            ctx.assertEquals((Object)"doe", (Object)result0.getString(2));
            Row result1 = (Row)it.next();
            ctx.assertEquals((Object)2, (Object)result1.getInteger(0));
            ctx.assertEquals((Object)"jane", (Object)result1.getString(1));
            ctx.assertEquals((Object)"doe", (Object)result1.getString(2));
        }));
    }

    @Test
    public void testInsertWithParameters(TestContext ctx) throws Exception {
        SqlConnection conn = this.connection();
        String sql = "INSERT INTO insert_table VALUES (?, ?, ?, ?);";
        LocalDate expected = LocalDate.of(2002, 2, 2);
        conn.preparedQuery(sql).execute(Tuple.of((Object)0, (Object)"doe", (Object)"jane", (Object)expected), ctx.asyncAssertSuccess(arg_0 -> ClientTest.lambda$testInsertWithParameters$2((SqlClient)conn, ctx, expected, arg_0)));
    }

    @Test
    public void testTransactionCommit(TestContext ctx) throws Exception {
        this.testTransaction(ctx, true);
    }

    @Test
    public void testTransactionRollback(TestContext ctx) throws Exception {
        this.testTransaction(ctx, false);
    }

    private void testTransaction(TestContext testCtx, boolean commit) throws Exception {
        SqlConnection conn = this.connection();
        conn.begin(testCtx.asyncAssertSuccess(tx -> {
            String sql = "INSERT INTO insert_table VALUES (?, ?, ?, ?);";
            LocalDate expected = LocalDate.of(2002, 2, 2);
            conn.preparedQuery(sql).execute(Tuple.of((Object)0, (Object)"doe", (Object)"jane", (Object)expected), testCtx.asyncAssertSuccess(rowSet -> {
                if (commit) {
                    tx.commit(testCtx.asyncAssertSuccess(v2 -> conn.preparedQuery("SElECT DOB FROM insert_table WHERE id=?").execute(Tuple.of((Object)0), testCtx.asyncAssertSuccess(rs -> {
                        testCtx.assertEquals((Object)1, (Object)rs.size());
                        testCtx.assertEquals((Object)expected, (Object)((Row)rs.iterator().next()).getLocalDate(0));
                    }))));
                } else {
                    tx.rollback(testCtx.asyncAssertSuccess(v2 -> conn.preparedQuery("SElECT DOB FROM insert_table WHERE id=?").execute(Tuple.of((Object)0), testCtx.asyncAssertSuccess(rs -> testCtx.assertEquals((Object)0, (Object)rs.size())))));
                }
            }));
        }));
    }

    @Test
    public void testStream(TestContext should) {
        this.client.withTransaction(tx -> tx.prepare("SELECT CURRENT_DATE AS today, CURRENT_TIME AS now FROM (VALUES(0))").map(pS -> pS.createStream(200)).flatMap(stream -> Future.future(promise -> {
            ArrayList rows = new ArrayList();
            stream.exceptionHandler(arg_0 -> ((Promise)promise).fail(arg_0));
            stream.endHandler(v -> promise.complete((Object)rows));
            stream.handler(row -> {
                should.assertEquals((Object)0, (Object)rows.size());
                rows.add(row);
            });
        }))).onComplete(should.asyncAssertSuccess(rows -> should.assertEquals((Object)1, (Object)rows.size())));
    }

    private static /* synthetic */ void lambda$testInsertWithParameters$2(SqlClient conn, TestContext ctx, LocalDate expected, RowSet rowSet) {
        conn.preparedQuery("SElECT DOB FROM insert_table WHERE id=?").execute(Tuple.of((Object)0), ctx.asyncAssertSuccess(rs -> {
            ctx.assertEquals((Object)1, (Object)rs.size());
            ctx.assertEquals((Object)expected, (Object)((Row)rs.iterator().next()).getLocalDate(0));
        }));
    }
}

