/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.Vertx;
import io.vertx.ext.jdbc.DBConfigs;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.unit.TestContext;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.sqlclient.PoolOptions;
import org.junit.After;
import org.junit.Before;

public class ClientTestBase {
    protected Vertx vertx;
    protected JDBCPool client;

    @Before
    public void setUp() throws Exception {
        JDBCClientTestBase.resetDb(ClientTestBase.class);
        this.vertx = Vertx.vertx();
        this.client = JDBCPool.pool((Vertx)this.vertx, (JDBCConnectOptions)this.connectOptions(), (PoolOptions)this.poolOptions());
    }

    protected JDBCConnectOptions connectOptions() {
        return new JDBCConnectOptions().setJdbcUrl(DBConfigs.hsqldb(ClientTestBase.class).getString("url"));
    }

    protected PoolOptions poolOptions() {
        return new PoolOptions().setMaxSize(1);
    }

    @After
    public void after(TestContext ctx) throws Exception {
        this.client.close(ctx.asyncAssertSuccess(v -> this.vertx.close(ctx.asyncAssertSuccess())));
    }
}

