/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.Context;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.sqlclient.PoolOptions;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@Ignore
@RunWith(value=VertxUnitRunner.class)
public class ConcurrencyTest
extends ClientTestBase {
    @Override
    protected JDBCConnectOptions connectOptions() {
        String url = "jdbc:h2:mem:test-" + JDBCConnectOptions.class.getSimpleName() + ";DB_CLOSE_DELAY=-1";
        return new JDBCConnectOptions().setJdbcUrl(url);
    }

    @Override
    protected PoolOptions poolOptions() {
        return super.poolOptions().setMaxSize(10);
    }

    @Test
    public void concurrentQueriesOnSameContext(TestContext should) {
        Async latch = should.async();
        this.client.query("CREATE ALIAS SLEEP FOR \"io.vertx.ext.jdbc.PoolTest.sleep\";").execute().onComplete(should.asyncAssertSuccess(r -> latch.complete()));
        latch.awaitSuccess(20000L);
        int n = 10;
        Context ctx = this.vertx.getOrCreateContext();
        Async test = should.async(n);
        for (int i = 0; i < n; ++i) {
            this.client.withConnection(conn -> {
                should.assertEquals((Object)ctx, (Object)this.vertx.getOrCreateContext());
                return conn.query("SELECT SLEEP(1000)").execute();
            }).onComplete(should.asyncAssertSuccess(v -> test.countDown()));
        }
        test.awaitSuccess(2000L);
    }
}

