/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.impl.actions.SQLValueProvider;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.jdbc.spi.impl.JDBCDecoderImpl;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.jdbcclient.impl.AgroalCPDataSourceProvider;
import io.vertx.jdbcclient.impl.actions.JDBCColumnDescriptor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import oracle.sql.TIMESTAMPTZ;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JDBCPoolColumnDescOracleExtTest
extends ClientTestBase {
    private static final List<String> SQL = new ArrayList<String>();
    private JDBCConnectOptions options;

    @Override
    @Before
    public void setUp() throws Exception {
        String jdbcUrl = "jdbc:oracle:thin:@127.0.0.1:1521:xe";
        String username = "sys as sysdba";
        String password = "vertx";
        Connection conn = DriverManager.getConnection(jdbcUrl, username, password);
        for (String sql : SQL) {
            try {
                conn.createStatement().execute(sql);
            }
            catch (SQLException sQLException) {}
        }
        this.options = new JDBCConnectOptions().setJdbcUrl(jdbcUrl).setUser(username).setPassword(password);
        this.vertx = Vertx.vertx();
        JsonObject extraOptions = new JsonObject().put("decoderCls", (Object)CustomDecoder.class.getName());
        DataSourceProvider provider = new AgroalCPDataSourceProvider(this.options, this.poolOptions()).init(extraOptions);
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSourceProvider)provider);
    }

    @Override
    protected JDBCConnectOptions connectOptions() {
        return this.options;
    }

    @Test
    @Ignore(value="Cannot run this in CI as we can't install Oracle")
    public void testColumnDesc(TestContext should) {
        this.client.query("SELECT id, name, created FROM my_table1").execute(should.asyncAssertSuccess(rows -> should.verify(v -> {
            Assert.assertEquals((long)1L, (long)rows.size());
            Row row = (Row)rows.iterator().next();
            MatcherAssert.assertThat((Object)row.getValue(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Number.class)));
            Assert.assertEquals((Object)"foo", (Object)row.getValue(1));
            MatcherAssert.assertThat((Object)row.getValue(2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(OffsetDateTime.class)));
            List columnDescriptors = rows.columnDescriptors();
            Assert.assertEquals((long)3L, (long)columnDescriptors.size());
            JDBCPoolColumnDescOracleExtTest.verifyDesc((ColumnDescriptor)columnDescriptors.get(0), "ID", "NUMBER", JDBCType.NUMERIC);
            JDBCPoolColumnDescOracleExtTest.verifyDesc((ColumnDescriptor)columnDescriptors.get(1), "NAME", "VARCHAR2", JDBCType.VARCHAR);
            JDBCPoolColumnDescOracleExtTest.verifyDesc((ColumnDescriptor)columnDescriptors.get(2), "CREATED", "TIMESTAMP WITH TIME ZONE", null);
        })));
    }

    private static void verifyDesc(ColumnDescriptor desc, String name, String typeName, JDBCType jdbcType) {
        Assert.assertEquals((Object)name, (Object)desc.name());
        Assert.assertFalse((boolean)desc.isArray());
        Assert.assertEquals((Object)typeName, (Object)desc.typeName());
        Assert.assertEquals((Object)jdbcType, (Object)desc.jdbcType());
    }

    static {
        SQL.add("DROP TABLE my_table1");
        SQL.add("CREATE TABLE my_table1 (    id NUMBER GENERATED ALWAYS AS IDENTITY PRIMARY KEY,    name VARCHAR2(100) NOT NULL,    created TIMESTAMP WITH TIME ZONE NOT NULL)");
        SQL.add("INSERT INTO my_table1 (name, created) VALUES (    'foo',    TO_TIMESTAMP_TZ('1999-12-01 11:00:00 -8:00','YYYY-MM-DD HH:MI:SS TZH:TZM'))");
    }

    public static class CustomDecoder
    extends JDBCDecoderImpl {
        protected Object decodeSpecificVendorType(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
            Object value = valueProvider.apply(null);
            if (value instanceof TIMESTAMPTZ) {
                TIMESTAMPTZ timestamptz = (TIMESTAMPTZ)value;
                return timestamptz.toOffsetDateTime();
            }
            return super.decodeSpecificVendorType(valueProvider, descriptor);
        }
    }
}

