/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JDBCPoolColumnDescTest
extends ClientTestBase {
    private static final JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl("jdbc:hsqldb:mem:" + JDBCPoolColumnDescTest.class.getSimpleName() + "?shutdown=true");
    private static final List<String> SQL = new ArrayList<String>();

    public static void resetDb() throws Exception {
        Connection conn = DriverManager.getConnection(options.getJdbcUrl());
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        JDBCPoolColumnDescTest.resetDb();
        super.setUp();
    }

    @Override
    protected JDBCConnectOptions connectOptions() {
        return options;
    }

    @Test
    public void testColumnDesc(TestContext should) {
        this.client.query("SELECT id AS key, name, scores FROM t").execute(should.asyncAssertSuccess(rows -> should.verify(v -> {
            Assert.assertEquals((long)1L, (long)rows.size());
            List columnDescriptors = rows.columnDescriptors();
            Assert.assertEquals((long)3L, (long)columnDescriptors.size());
            JDBCPoolColumnDescTest.verifyDesc((ColumnDescriptor)columnDescriptors.get(0), "KEY", false, "INTEGER", JDBCType.INTEGER);
            JDBCPoolColumnDescTest.verifyDesc((ColumnDescriptor)columnDescriptors.get(1), "NAME", false, "VARCHAR", JDBCType.VARCHAR);
            JDBCPoolColumnDescTest.verifyDesc((ColumnDescriptor)columnDescriptors.get(2), "SCORES", true, "INTEGER ARRAY", JDBCType.ARRAY);
        })));
    }

    private static void verifyDesc(ColumnDescriptor desc, String name, boolean array, String typeName, JDBCType jdbcType) {
        Assert.assertEquals((Object)name, (Object)desc.name());
        Assert.assertEquals((Object)array, (Object)desc.isArray());
        Assert.assertEquals((Object)typeName, (Object)desc.typeName());
        Assert.assertEquals((Object)jdbcType, (Object)desc.jdbcType());
    }

    static {
        SQL.add("DROP TABLE IF EXISTS t");
        SQL.add("CREATE TABLE t (id INT PRIMARY KEY, name VARCHAR(20), scores INT ARRAY)");
        SQL.add("INSERT INTO t VALUES 1, 'John', ARRAY[157,215,78]");
    }
}

