/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.sql.Connection;
import java.sql.DriverManager;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JDBCPoolCustomTypesTest
extends ClientTestBase {
    private static final JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl("jdbc:h2:mem:test-" + JDBCPoolCustomTypesTest.class.getSimpleName() + ";DB_CLOSE_DELAY=-1");
    private static final List<String> SQL = new ArrayList<String>();

    public static void resetDb() throws Exception {
        Connection conn = DriverManager.getConnection(options.getJdbcUrl());
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        JDBCPoolCustomTypesTest.resetDb();
        super.setUp();
    }

    @Override
    protected JDBCConnectOptions connectOptions() {
        return options;
    }

    @Test
    public void testSelectUUID(TestContext should) {
        Async test = should.async();
        String sql = "SELECT u FROM t";
        this.client.query(sql).execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)1, (Object)rows.size());
            for (Row row : rows) {
                should.assertNotNull((Object)row.getUUID(0));
                UUID uUID = row.getUUID(0);
            }
            test.complete();
        });
    }

    @Test
    public void testCustomInsert(TestContext should) {
        Async test = should.async();
        String sql = "INSERT INTO t (u, t, d, ts) VALUES (?, ?, ?, ?)";
        this.client.preparedQuery(sql).execute(Tuple.of((Object)UUID.randomUUID(), (Object)LocalTime.of(9, 0, 0), (Object)LocalDate.of(2020, Month.JUNE, 19), (Object)LocalDateTime.now())).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertEquals((Object)1, (Object)rows.rowCount());
            this.client.query("SELECT u, t, d, ts from t where ts is not null").execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows2 -> {
                should.assertEquals((Object)1, (Object)rows2.size());
                for (Row row : rows2) {
                    should.assertNotNull((Object)row.getUUID("U"));
                    should.assertNotNull((Object)row.getLocalTime("T"));
                    should.assertNotNull((Object)row.getLocalDate("D"));
                    should.assertNotNull((Object)row.getLocalDateTime("TS"));
                }
                test.complete();
            });
        });
    }

    static {
        SQL.add("drop table if exists t");
        SQL.add("create table t (u UUID, d DATE, t TIME, ts TIMESTAMP)");
        SQL.add("insert into t (u) values (random_uuid())");
    }
}

