/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.sql.Connection;
import java.sql.DriverManager;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JDBCPoolDateTimeTest
extends ClientTestBase {
    private static final JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl("jdbc:h2:mem:test-" + JDBCPoolDateTimeTest.class.getSimpleName() + ";DB_CLOSE_DELAY=-1");
    private static final List<String> SQL = new ArrayList<String>();

    public static void resetDb() throws Exception {
        Connection conn = DriverManager.getConnection(options.getJdbcUrl());
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        JDBCPoolDateTimeTest.resetDb();
        super.setUp();
    }

    @Override
    protected JDBCConnectOptions connectOptions() {
        return options;
    }

    @Test
    public void testLocalDateTime(TestContext should) {
        Async test = should.async();
        String sql = "INSERT INTO tt (ts) VALUES (?)";
        LocalDateTime localDateTime = LocalDateTime.parse("2021-07-21T19:16:33");
        System.out.println(localDateTime);
        this.client.preparedQuery(sql).execute(Tuple.of((Object)localDateTime)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> this.client.query("SELECT ts FROM tt").execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows2 -> {
            Row row = (Row)rows2.iterator().next();
            should.assertEquals((Object)localDateTime, (Object)row.getLocalDateTime("TS"));
            test.complete();
        }));
    }

    @Test
    public void testOffsetDateTime(TestContext should) {
        Async flag = should.async();
        String sql = "INSERT INTO tt (tstz) VALUES (?)";
        OffsetDateTime odt = OffsetDateTime.parse("2021-07-21T19:16:33+03:00");
        System.out.println(odt);
        this.client.preparedQuery(sql).execute(Tuple.of((Object)odt)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> this.client.query("SELECT tstz from tt").execute().onSuccess(rows2 -> {
            Row row = (Row)rows2.iterator().next();
            should.verify(i -> {
                Object value = row.getValue("TSTZ");
                should.assertNotNull(value);
                should.assertEquals(OffsetDateTime.class, value.getClass());
                should.assertEquals((Object)odt, value);
            });
            flag.complete();
        }).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)));
    }

    @Test
    public void testLocalTime(TestContext should) {
        Async flag = should.async();
        String sql = "INSERT INTO tt (t) VALUES (?)";
        LocalTime localTime = LocalTime.parse("19:16:33");
        System.out.println(localTime);
        this.client.preparedQuery(sql).execute(Tuple.of((Object)localTime)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> this.client.query("SELECT t from tt").execute().onSuccess(rows2 -> {
            Row row = (Row)rows2.iterator().next();
            should.verify(i -> {
                Object value = row.getValue("T");
                should.assertNotNull(value);
                should.assertEquals(LocalTime.class, value.getClass());
                should.assertEquals((Object)localTime, value);
            });
            flag.complete();
        }).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)));
    }

    @Test
    public void testOffsetTime(TestContext should) {
        Async flag = should.async();
        String sql = "INSERT INTO tt (ttz) VALUES (?)";
        OffsetTime offsetTime = OffsetTime.of(LocalTime.of(7, 0), ZoneOffset.ofHours(7));
        System.out.println(offsetTime);
        this.client.preparedQuery(sql).execute(Tuple.of((Object)offsetTime)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> this.client.query("SELECT ttz from tt").execute().onSuccess(rows2 -> {
            Row row = (Row)rows2.iterator().next();
            should.verify(i -> {
                Object value = row.getValue("TTZ");
                should.assertNotNull(value);
                should.assertEquals(OffsetTime.class, value.getClass());
                should.assertEquals((Object)offsetTime, value);
            });
            flag.complete();
        }).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)));
    }

    static {
        SQL.add("drop table if exists tt");
        SQL.add("create table tt (tstz TIMESTAMP WITH TIME ZONE, ts TIMESTAMP, t TIME, ttz TIME WITH TIME ZONE )");
    }
}

