/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import com.zaxxer.hikari.HikariDataSource;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.jdbc.spi.impl.AgroalCPDataSourceProvider;
import io.vertx.ext.jdbc.spi.impl.C3P0DataSourceProvider;
import io.vertx.ext.jdbc.spi.impl.HikariCPDataSourceProvider;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.test.fakemetrics.FakePoolMetrics;
import javax.sql.DataSource;
import org.h2.Driver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JDBCPoolInitTest
extends ClientTestBase {
    private String poolMetricsPoolName;

    @Override
    @Before
    public void setUp() throws Exception {
        this.poolMetricsPoolName = null;
        MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true);
        metricsOptions.setFactory(vertxOptions -> new VertxMetrics(){

            public PoolMetrics<?> createPoolMetrics(String poolType, String poolName, int maxPoolSize) {
                if (poolType.equals("datasource")) {
                    Assert.assertEquals((Object)"datasource", (Object)poolType);
                    JDBCPoolInitTest.this.poolMetricsPoolName = poolName;
                    return new FakePoolMetrics(poolName, maxPoolSize);
                }
                return super.createPoolMetrics(poolType, poolName, maxPoolSize);
            }
        });
        VertxOptions vertxOptions2 = new VertxOptions().setMetricsOptions(metricsOptions);
        this.vertx = Vertx.vertx((VertxOptions)vertxOptions2);
    }

    @Test
    public void test_init_pool_by_Hikari_provider(TestContext should) {
        JsonObject config = new JsonObject().put("provider_class", (Object)HikariCPDataSourceProvider.class.getName()).put("jdbcUrl", (Object)"jdbc:h2:mem:testDB?shutdown=true");
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSourceProvider)DataSourceProvider.create((JsonObject)config));
        this.simpleAssertSuccess(should);
    }

    @Test
    public void test_init_pool_by_Hikari_config(TestContext should) {
        JsonObject config = new JsonObject().put("provider_class", (Object)HikariCPDataSourceProvider.class.getName()).put("jdbcUrl", (Object)"jdbc:h2:mem:testDB?shutdown=true").put("driverClassName", (Object)Driver.class.getName());
        this.client = JDBCPool.pool((Vertx)this.vertx, (JsonObject)config);
        this.simpleAssertSuccess(should);
    }

    @Test
    public void test_init_pool_by_C3P0_config(TestContext should) {
        JsonObject config = new JsonObject().put("provider_class", (Object)C3P0DataSourceProvider.class.getName()).put("url", (Object)"jdbc:h2:mem:testDB?shutdown=true");
        this.client = JDBCPool.pool((Vertx)this.vertx, (JsonObject)config);
        this.simpleAssertSuccess(should);
    }

    @Test
    public void test_init_pool_by_C3P0_provider(TestContext should) {
        JsonObject config = new JsonObject().put("provider_class", (Object)C3P0DataSourceProvider.class.getName()).put("url", (Object)"jdbc:h2:mem:testDB?shutdown=true").put("driver_class", (Object)Driver.class.getName());
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSourceProvider)DataSourceProvider.create((JsonObject)config));
        this.simpleAssertSuccess(should);
    }

    @Test
    public void test_init_pool_by_Agroal_provider(TestContext should) {
        JsonObject config = new JsonObject().put("provider_class", (Object)AgroalCPDataSourceProvider.class.getName()).put("jdbcUrl", (Object)"jdbc:h2:mem:testDB?shutdown=true").put("principal", (Object)"").put("credential", (Object)"");
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSourceProvider)DataSourceProvider.create((JsonObject)config));
        this.simpleAssertSuccess(should);
    }

    @Test
    public void test_init_pool_by_Agroal_config(TestContext should) {
        JsonObject config = new JsonObject().put("provider_class", (Object)AgroalCPDataSourceProvider.class.getName()).put("jdbcUrl", (Object)"jdbc:h2:mem:testDB?shutdown=true").put("driverClassName", (Object)Driver.class.getName()).put("principal", (Object)"").put("credential", (Object)"");
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSourceProvider)DataSourceProvider.create((JsonObject)config));
        this.simpleAssertSuccess(should);
    }

    private Future<Void> simpleAssertSuccess(TestContext should) {
        return this.client.query("SELECT * FROM INFORMATION_SCHEMA.TABLES").execute().onComplete(should.asyncAssertSuccess(rows -> should.assertTrue(rows.size() > 0))).map(ignored -> null);
    }

    @Test
    public void test_init_pool_by_existing_datasource(TestContext should) {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl("jdbc:h2:mem:testDB?shutdown=true");
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSource)ds);
        this.simpleAssertSuccess(should);
    }

    @Test
    public void test_init_pool_by_existing_datasource_custom_config(TestContext should) {
        JsonObject config = new JsonObject().put("url", (Object)"jdbc:h2:mem:testDB?shutdown=true").put("user", (Object)"").put("database", (Object)"testDB").put("maxPoolSize", (Object)10);
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl("jdbc:h2:mem:testDB?shutdown=true");
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSource)ds, (JsonObject)config);
        this.simpleAssertSuccess(should);
    }

    @Test
    public void test_init_pool_with_datasource_name(TestContext should) {
        String datasourceName = "customDatasourceName";
        JsonObject config = new JsonObject().put("url", (Object)"jdbc:h2:mem:testDB?shutdown=true").put("datasourceName", (Object)"customDatasourceName");
        this.client = JDBCPool.pool((Vertx)this.vertx, (JsonObject)config);
        this.simpleAssertSuccess(should).onComplete(should.asyncAssertSuccess(nil -> should.assertEquals((Object)"customDatasourceName", (Object)this.poolMetricsPoolName)));
    }

    @Test
    public void test_init_pool_without_datasource_name_uses_uuid_as_datasource_name(TestContext should) {
        JsonObject config = new JsonObject().put("url", (Object)"jdbc:h2:mem:testDB?shutdown=true");
        this.client = JDBCPool.pool((Vertx)this.vertx, (JsonObject)config);
        this.simpleAssertSuccess(should).onComplete(should.asyncAssertSuccess(nil -> should.assertTrue(this.poolMetricsPoolName.matches("^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$"))));
    }

    @Test
    public void test_init_pool_with_jdbc_connect_options_and_pool_options_uses_pool_name_as_datasource_name(TestContext should) {
        String poolName = "customPoolName";
        this.client = JDBCPool.pool((Vertx)this.vertx, (JDBCConnectOptions)new JDBCConnectOptions().setJdbcUrl("jdbc:h2:mem:testDB?shutdown=true"), (PoolOptions)new PoolOptions().setName("customPoolName"));
        this.simpleAssertSuccess(should).onComplete(should.asyncAssertSuccess(nil -> should.assertEquals((Object)"customPoolName", (Object)this.poolMetricsPoolName)));
    }

    @Test
    public void test_init_pool_with_datasource_provider_uses_datasource_name_from_provider_config(TestContext should) {
        String datasourceName = "customDatasourceName";
        JsonObject config = new JsonObject().put("provider_class", (Object)AgroalCPDataSourceProvider.class.getName()).put("principal", (Object)"").put("credential", (Object)"").put("jdbcUrl", (Object)"jdbc:h2:mem:testDB?shutdown=true").put("datasourceName", (Object)"customDatasourceName");
        this.client = JDBCPool.pool((Vertx)this.vertx, (DataSourceProvider)DataSourceProvider.create((JsonObject)config));
        this.simpleAssertSuccess(should).onComplete(should.asyncAssertSuccess(nil -> should.assertEquals((Object)"customDatasourceName", (Object)this.poolMetricsPoolName)));
    }
}

