/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.jdbcclient.SqlOutParam;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JDBCPoolStoredProceduresTest
extends ClientTestBase {
    private static final JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl("jdbc:hsqldb:mem:" + JDBCPoolStoredProceduresTest.class.getSimpleName() + "?shutdown=true");
    private static final List<String> SQL = new ArrayList<String>();

    public static void resetDb() throws SQLException {
        Connection conn = DriverManager.getConnection(options.getJdbcUrl());
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    @Override
    public void setUp() throws Exception {
        JDBCPoolStoredProceduresTest.resetDb();
        super.setUp();
    }

    @Override
    protected JDBCConnectOptions connectOptions() {
        return options;
    }

    @Test
    public void testStoredProcedureIn(TestContext should) {
        Async test = should.async();
        String sql = "{call new_customer(?, ?)}";
        this.client.preparedQuery(sql).execute(Tuple.of((Object)"Paulo", (Object)"Lopes")).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            this.client.query("SELECT * from customers where firstname = 'Paulo'").execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows1 -> {
                should.assertNotNull(rows1);
                should.assertEquals((Object)1, (Object)rows1.size());
                for (Row row : rows1) {
                    should.assertNotNull((Object)row.getInteger(0));
                    should.assertEquals((Object)"Paulo", (Object)row.getString(1));
                    should.assertEquals((Object)"Lopes", (Object)row.getString(2));
                    should.assertNotNull((Object)row.getLocalDateTime(3));
                }
                test.complete();
            });
        });
    }

    @Test
    public void testStoredProcedureInOut(TestContext should) {
        Async test = should.async();
        String sql = "{call customer_lastname(?, ?)}";
        this.client.preparedQuery(sql).execute(Tuple.of((Object)"John", (Object)SqlOutParam.OUT((JDBCType)JDBCType.VARCHAR))).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)1, (Object)rows.size());
            should.assertTrue(((Boolean)rows.property(JDBCPool.OUTPUT)).booleanValue());
            should.assertEquals((Object)"Doe", (Object)((Row)rows.iterator().next()).getString(0));
            test.complete();
        });
    }

    static {
        System.setProperty("textdb.allow_full_path", "true");
        System.setProperty("statement.separator", ";;");
        SQL.add("drop table if exists customers cascade");
        SQL.add("create table customers(id integer generated by default as identity, firstname varchar(50), lastname varchar(50), added timestamp)");
        SQL.add("insert into customers(firstname, lastname) values ('John', 'Doe')");
        SQL.add("drop procedure if exists new_customer");
        SQL.add("create procedure new_customer(firstname varchar(50), lastname varchar(50))\n  modifies sql data\n  insert into customers values (default, firstname, lastname, current_timestamp)");
        SQL.add("drop procedure if exists customer_lastname");
        SQL.add("create procedure customer_lastname(IN firstname varchar(50), OUT lastname varchar(50))\n  modifies sql data\n  select lastname into lastname from customers where firstname = firstname");
        SQL.add("drop function if exists an_hour_before");
        SQL.add("create function an_hour_before()\n  returns timestamp\n  return now() - 1 hour");
        SQL.add("drop procedure if exists times2");
        SQL.add("create procedure times2(INOUT param INT)\n  modifies sql data\n  SET param = param * 2");
    }
}

