/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.jdbcclient.JDBCUtils;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JDBCPoolTest
extends ClientTestBase {
    private static final JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl("jdbc:hsqldb:mem:" + JDBCPoolTest.class.getSimpleName() + "?shutdown=true");
    private static final List<String> SQL = new ArrayList<String>();

    @BeforeClass
    public static void resetDb() throws Exception {
        Connection conn = DriverManager.getConnection(options.getJdbcUrl());
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    @Override
    protected JDBCConnectOptions connectOptions() {
        return options;
    }

    @Test
    public void testSelect(TestContext should) {
        Async test = should.async();
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        this.client.query(sql).execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)2, (Object)rows.size());
            should.assertTrue(rows.columnsNames().containsAll(Arrays.asList("ID", "FNAME", "LNAME")));
            int cnt = 0;
            for (Row row : rows) {
                switch (++cnt) {
                    case 1: {
                        should.assertEquals((Object)1, (Object)row.getInteger(0));
                        should.assertEquals((Object)"john", (Object)row.getString(1));
                        should.assertEquals((Object)"doe", (Object)row.getString(2));
                        should.assertEquals((Object)1, (Object)row.getInteger("ID"));
                        should.assertEquals((Object)"john", (Object)row.getString("FNAME"));
                        should.assertEquals((Object)"doe", (Object)row.getString("LNAME"));
                        break;
                    }
                    case 2: {
                        should.assertEquals((Object)2, (Object)row.getInteger(0));
                        should.assertEquals((Object)"jane", (Object)row.getString(1));
                        should.assertEquals((Object)"doe", (Object)row.getString(2));
                        should.assertEquals((Object)2, (Object)row.getInteger("ID"));
                        should.assertEquals((Object)"jane", (Object)row.getString("FNAME"));
                        should.assertEquals((Object)"doe", (Object)row.getString("LNAME"));
                    }
                }
            }
            should.assertEquals((Object)2, (Object)cnt);
            test.complete();
        });
    }

    @Test
    public void testInsert(TestContext should) {
        Async test = should.async();
        String sql = "INSERT INTO insert_table (FNAME, LNAME) VALUES (?,?)";
        this.client.preparedQuery(sql).execute(Tuple.of((Object)"Paulo", (Object)"Lopes")).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertEquals((Object)-1, (Object)rows.size());
            should.assertEquals((Object)1, (Object)rows.rowCount());
            Row lastInsertId = (Row)rows.property(JDBCPool.GENERATED_KEYS);
            should.assertNotNull((Object)lastInsertId);
            should.assertTrue(lastInsertId.getLong(0) > 0L);
            test.complete();
        });
    }

    @Test
    public void testSelectWithParams(TestContext should) {
        Async test = should.async();
        String sql = "SELECT ID, FNAME, LNAME FROM select_table WHERE FNAME = ?";
        this.client.preparedQuery(sql).execute(Tuple.of((Object)"john")).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)1, (Object)rows.size());
            should.assertTrue(rows.columnsNames().containsAll(Arrays.asList("ID", "FNAME", "LNAME")));
            for (Row row : rows) {
                should.assertEquals((Object)1, (Object)row.getInteger(0));
                should.assertEquals((Object)"john", (Object)row.getString(1));
                should.assertEquals((Object)"doe", (Object)row.getString(2));
                should.assertEquals((Object)1, (Object)row.getInteger("ID"));
                should.assertEquals((Object)"john", (Object)row.getString("FNAME"));
                should.assertEquals((Object)"doe", (Object)row.getString("LNAME"));
            }
            test.complete();
        });
    }

    @Test
    public void testSelectWithLabels(TestContext should) {
        Async test = should.async();
        String sql = "SELECT ID as \"IdLabel\", FNAME as \"first_name\", LNAME as \"LAST.NAME\" FROM select_table WHERE fname = ?";
        this.client.preparedQuery(sql).execute(Tuple.of((Object)"john")).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)1, (Object)rows.size());
            should.assertTrue(rows.columnsNames().containsAll(Arrays.asList("IdLabel", "first_name", "LAST.NAME")));
            for (Row row : rows) {
                should.assertEquals((Object)1, (Object)row.getInteger(0));
                should.assertEquals((Object)"john", (Object)row.getString(1));
                should.assertEquals((Object)"doe", (Object)row.getString(2));
                should.assertEquals((Object)1, (Object)row.getInteger("IdLabel"));
                should.assertEquals((Object)"john", (Object)row.getString("first_name"));
                should.assertEquals((Object)"doe", (Object)row.getString("LAST.NAME"));
            }
            test.complete();
        });
    }

    @Test
    public void testSelectWithTx(TestContext should) {
        Async test = should.async();
        String sql = "INSERT INTO insert_table VALUES (?, ?, ?, ?);";
        this.client.getConnection().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(conn -> conn.begin().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(tx -> conn.preparedQuery(sql).execute(Tuple.of(null, (Object)"smith", (Object)"john", (Object)"2003-03-03")).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            should.assertEquals((Object)-1, (Object)rows.size());
            should.assertEquals((Object)1, (Object)rows.rowCount());
            int id = ((Row)rows.property(JDBCPool.GENERATED_KEYS)).getInteger(0);
            conn.preparedQuery("SELECT LNAME FROM insert_table WHERE id = ?").execute(Tuple.of((Object)id)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows1 -> {
                should.assertEquals((Object)1, (Object)rows1.size());
                should.assertEquals((Object)"smith", (Object)((Row)rows1.iterator().next()).getString("LNAME"));
                tx.rollback().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(v -> conn.close().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(v1 -> this.client.preparedQuery("SELECT LNAME FROM insert_table WHERE id = ?").execute(Tuple.of((Object)id)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows2 -> {
                    should.assertEquals((Object)0, (Object)rows2.size());
                    test.complete();
                })));
            });
        })));
    }

    @Test
    public void testSelectInvalid(TestContext should) {
        Async test = should.async();
        String sql = "SELECT FROM WHERE FOO BAR";
        this.client.query(sql).execute().onFailure(err -> test.complete()).onSuccess(rows -> should.fail("Broken SQL should fail"));
    }

    @Test
    public void testSelectBlob(TestContext should) {
        Async test = should.async();
        String sql = "SELECT b FROM blob_table";
        this.client.query(sql).execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertEquals((Object)1, (Object)rows.size());
            for (Row row : rows) {
                should.assertNotNull((Object)row.getBuffer(0));
            }
            test.complete();
        });
    }

    @Test
    public void testSelectClob(TestContext should) {
        Async test = should.async();
        String sql = "SELECT c FROM blob_table";
        this.client.query(sql).execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertEquals((Object)1, (Object)rows.size());
            for (Row row : rows) {
                should.assertNotNull((Object)row.getString(0));
            }
            test.complete();
        });
    }

    @Test
    public void testSelectArray(TestContext should) {
        Async test = should.async();
        String sql = "SELECT a FROM blob_table";
        this.client.query(sql).execute().onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertEquals((Object)1, (Object)rows.size());
            for (Row row : rows) {
                should.assertNotNull((Object)row.getArrayOfIntegers(0));
                should.assertEquals((Object)1, (Object)row.getArrayOfIntegers(0)[0]);
                should.assertEquals((Object)2, (Object)row.getArrayOfIntegers(0)[1]);
                should.assertEquals((Object)3, (Object)row.getArrayOfIntegers(0)[2]);
            }
            test.complete();
        });
    }

    @Test
    public void testBatchPreparedStatement(TestContext ctx) {
        this.client.query("drop table if exists t").execute(ctx.asyncAssertSuccess(res1 -> this.client.query("create table t (u BIGINT)").execute(ctx.asyncAssertSuccess(res2 -> {
            List<Tuple> batch = Arrays.asList(Tuple.of((Object)System.currentTimeMillis()), Tuple.of((Object)System.currentTimeMillis()), Tuple.of((Object)System.currentTimeMillis()));
            this.client.preparedQuery("insert into t (u) values (?)").executeBatch(batch, ctx.asyncAssertSuccess(res -> ctx.assertEquals((Object)3, (Object)res.rowCount())));
        }))));
    }

    @Test
    public void testPreparedStatementWithBufferParam(TestContext should) {
        Buffer buffer = Buffer.buffer((String)"Hello world!");
        this.client.query("drop table if exists t").execute().compose(res1 -> this.client.query("create table t (b BLOB)").execute().compose(res2 -> this.client.preparedQuery("insert into t (b) values (?)").execute(Tuple.of((Object)buffer)).compose(res3 -> this.client.query("select b from t").execute().onComplete(should.asyncAssertSuccess(rows -> {
            should.assertEquals((Object)1, (Object)rows.size());
            rows.forEach(row -> {
                Buffer actual = row.getBuffer(0);
                should.assertNotNull((Object)actual);
                should.assertEquals((Object)buffer, (Object)actual);
            });
        })))));
    }

    @Test
    public void testConnectionReturnedToPoolOnFailingQueryExecution(TestContext should) {
        Async test = should.async();
        String sql = "SELECT FROM WHERE FOO BAR";
        this.client.query(sql).execute().onFailure(err -> {
            should.assertTrue(err instanceof SQLSyntaxErrorException, "Broken SQL should fail with SQLSyntaxErrorException");
            this.client.query(sql).execute().onFailure(err2 -> {
                should.assertTrue(err2 instanceof SQLSyntaxErrorException, "Broken SQL should fail with SQLSyntaxErrorException");
                test.complete();
            }).onSuccess(rows -> should.fail("Broken SQL should fail"));
        }).onSuccess(rows -> should.fail("Broken SQL should fail"));
    }

    @Test
    public void testConnectionReturnedToPoolOnFailingQueryExecutionWhenUsingWithConnection(TestContext should) {
        Async test = should.async();
        String sql = "SELECT FROM WHERE FOO BAR";
        this.client.withConnection(conn -> conn.query(sql).execute().onFailure(err -> {
            should.assertTrue(err instanceof SQLSyntaxErrorException, "Broken SQL should fail with SQLSyntaxErrorException");
            this.client.withConnection(conn2 -> conn2.query(sql).execute().onFailure(err2 -> {
                should.assertTrue(err2 instanceof SQLSyntaxErrorException, "Broken SQL should fail with SQLSyntaxErrorException");
                test.complete();
            }).onSuccess(rows -> should.fail("Broken SQL should fail")));
        }).onSuccess(rows -> should.fail("Broken SQL should fail")));
    }

    @Test
    public void testUnwrapToJDBCConnection(TestContext should) {
        this.client.getConnection().onComplete(should.asyncAssertSuccess(conn -> {
            Connection c = JDBCUtils.unwrap((SqlConnection)conn);
            Assert.assertNotNull((Object)c);
        }));
    }

    static {
        System.setProperty("textdb.allow_full_path", "true");
        SQL.add("drop table if exists select_table;");
        SQL.add("drop table if exists insert_table;");
        SQL.add("drop table if exists insert_table2;");
        SQL.add("drop table if exists update_table;");
        SQL.add("drop table if exists delete_table;");
        SQL.add("drop table if exists blob_table;");
        SQL.add("drop table if exists big_table;");
        SQL.add("create table select_table (id int, lname varchar(255), fname varchar(255) );");
        SQL.add("insert into select_table values (1, 'doe', 'john');");
        SQL.add("insert into select_table values (2, 'doe', 'jane');");
        SQL.add("create table insert_table (id int generated by default as identity (start with 2 increment by 2) not null, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("create table insert_table2 (id int not null, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("create table update_table (id int, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("insert into update_table values (1, 'doe', 'john', '2001-01-01');");
        SQL.add("create table delete_table (id int, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("insert into delete_table values (1, 'doe', 'john', '2001-01-01');");
        SQL.add("insert into delete_table values (2, 'doe', 'jane', '2002-02-02');");
        SQL.add("create table blob_table (b blob, c clob, a int array default array[]);");
        SQL.add("insert into blob_table (b, c, a) values (load_file('pom.xml'), convert('Hello', clob),  ARRAY[1,2,3])");
        SQL.add("create table big_table(id int primary key, name varchar(255))");
        for (int i = 0; i < 200; ++i) {
            SQL.add("insert into big_table values(" + i + ", 'Hello')");
        }
    }
}

