/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.Vertx;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunnerWithParametersFactory;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.tck.TracingTestBase;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hsqldb.Server;
import org.junit.Assume;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=VertxUnitRunnerWithParametersFactory.class)
public class JDBCTracingTest
extends TracingTestBase {
    private static final List<String> SQL = Arrays.asList("DROP TABLE IF EXISTS immutable;\nCREATE TABLE immutable (id integer NOT NULL, message varchar(2048) NOT NULL, PRIMARY KEY (id));\nINSERT INTO immutable (id, message) VALUES (1, 'fortune: No such file or directory');\nINSERT INTO immutable (id, message) VALUES (2, 'A computer scientist is someone who fixes things that aren''t broken.');\nINSERT INTO immutable (id, message) VALUES (3, 'After enough decimal places, nobody gives a damn.');\nINSERT INTO immutable (id, message) VALUES (4, 'A bad random number generator: 1, 1, 1, 1, 1, 4.33e+67, 1, 1, 1');\nINSERT INTO immutable (id, message) VALUES (5, 'A computer program does what you tell it to do, not what you want it to do.');\nINSERT INTO immutable (id, message) VALUES (6, 'Emacs is a nice operating system, but I prefer UNIX. \u2014 Tom Christaensen');\nINSERT INTO immutable (id, message) VALUES (7, 'Any program that runs right is obsolete.');\nINSERT INTO immutable (id, message) VALUES (8, 'A list is only as strong as its weakest link. \u2014 Donald Knuth');\nINSERT INTO immutable (id, message) VALUES (9, 'Feature: A bug with seniority.');\nINSERT INTO immutable (id, message) VALUES (10, 'Computers make very fast, very accurate mistakes.');\nINSERT INTO immutable (id, message) VALUES (11, '<script>alert(\"This should not be displayed in a browser alert box.\");</script>');\nINSERT INTO immutable (id, message) VALUES (12, '\u30d5\u30ec\u30fc\u30e0\u30ef\u30fc\u30af\u306e\u30d9\u30f3\u30c1\u30de\u30fc\u30af');".split("\n"));
    private JDBCPool pool;
    private Server server;
    private final String connectionURL;
    private final int serverMode;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({0, "jdbc:hsqldb:hsql://localhost/xdb"}, {0, "jdbc:hsqldb:hsql://localhost:9001/xdb"}, {0, "jdbc:hsqldb:hsql://127.0.0.1/xdb"}, {0, "jdbc:hsqldb:hsql://127.0.0.1:9001/xdb"}, {1, "jdbc:hsqldb:mem:" + ClientTestBase.class.getSimpleName() + "?shutdown=true"});
    }

    public JDBCTracingTest(int serverMode, String connectionURL) {
        this.serverMode = serverMode;
        this.connectionURL = connectionURL;
    }

    public void setup() throws Exception {
        switch (this.serverMode) {
            case 0: {
                Path dbPath = Files.createTempDirectory("hsqldb-", new FileAttribute[0]);
                this.server = new Server();
                this.server.setDatabaseName(0, "xdb");
                this.server.setDatabasePath(0, "file:" + dbPath.toString());
                this.server.setPort(9001);
                this.server.start();
                Connection conn = DriverManager.getConnection(this.connectionURL, "SA", "");
                for (String statement : SQL) {
                    conn.createStatement().execute(statement);
                }
                break;
            }
            case 1: {
                JDBCClientTestBase.resetDb(ClientTestBase.class, SQL);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        super.setup();
    }

    public void teardown(TestContext ctx) {
        JDBCPool p = this.pool;
        this.pool = null;
        if (p != null) {
            try {
                p.close().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.teardown(ctx);
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    protected Pool createPool(Vertx vertx) {
        if (this.pool == null) {
            this.pool = JDBCPool.pool((Vertx)vertx, (JDBCConnectOptions)new JDBCConnectOptions().setJdbcUrl(this.connectionURL).setUser("SA").setPassword(""), (PoolOptions)new PoolOptions());
        }
        return this.pool;
    }

    protected String statement(String ... parts) {
        return String.join((CharSequence)"?", parts);
    }

    public void testTraceBatchQuery(TestContext ctx) {
        Assume.assumeTrue((boolean)false);
    }

    public void testTracePooledBatchQuery(TestContext ctx) {
        Assume.assumeTrue((boolean)false);
    }
}

