/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.Vertx;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.jdbcclient.impl.AgroalCPDataSourceProvider;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@Ignore(value="We can't run Oracle on CI")
@RunWith(value=VertxUnitRunner.class)
public class OracleRowIdTest {
    @ClassRule
    public static final RunTestOnContext rule = new RunTestOnContext();
    private static final List<String> SQL = new ArrayList<String>();
    private JDBCPool client;

    @Before
    public void setUp() throws Exception {
        String jdbcUrl = "jdbc:oracle:thin:@127.0.0.1:1521:xe";
        String username = "system";
        String password = "vertx";
        Connection conn = DriverManager.getConnection(jdbcUrl, username, password);
        for (String sql : SQL) {
            try {
                conn.createStatement().execute(sql);
            }
            catch (SQLException sQLException) {}
        }
        AgroalCPDataSourceProvider provider = new AgroalCPDataSourceProvider(new JDBCConnectOptions().setJdbcUrl(jdbcUrl).setUser(username).setPassword(password), new PoolOptions().setMaxSize(1));
        this.client = JDBCPool.pool((Vertx)rule.vertx(), (DataSourceProvider)provider);
    }

    @Test
    public void rowIdTest(TestContext should) {
        Async test = should.async();
        this.client.preparedQuery("INSERT INTO vegetables (name, amount) VALUES (?, ?)").execute(Tuple.of((Object)"pickle", (Object)5)).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows -> {
            should.assertNotNull(rows);
            Row lastInsertId = (Row)rows.property(JDBCPool.GENERATED_KEYS);
            byte[] newId = (byte[])lastInsertId.get(byte[].class, 0);
            should.assertNotNull((Object)newId);
            this.client.preparedQuery("SELECT * FROM vegetables WHERE rowid = ?").execute(Tuple.of((Object)new String(newId))).onFailure(arg_0 -> ((TestContext)should).fail(arg_0)).onSuccess(rows1 -> {
                for (Row row : rows1) {
                }
                test.complete();
            });
        });
    }

    static {
        SQL.add("DROP TABLE vegetables");
        SQL.add("CREATE TABLE vegetables (  id        NUMBER GENERATED ALWAYS as IDENTITY(START with 1 INCREMENT by 1),  name      VARCHAR2(40) NOT NULL,  amount    INT,  CONSTRAINT vegetables_pk PRIMARY KEY (id))");
    }
}

