/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.jdbcclient.ClientTestBase;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.data.MyObject;
import io.vertx.jdbcclient.data.MyObjectRowMapper;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.templates.RowMapper;
import io.vertx.sqlclient.templates.SqlTemplate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class SqlClientTemplatesTest
extends ClientTestBase {
    private static final JDBCConnectOptions options = new JDBCConnectOptions().setJdbcUrl("jdbc:h2:mem:" + SqlClientTemplatesTest.class.getSimpleName() + ";DB_CLOSE_DELAY=-1");
    private static final List<String> SQL = new ArrayList<String>();

    public static void resetDb() throws Exception {
        Connection conn = DriverManager.getConnection(options.getJdbcUrl());
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        SqlClientTemplatesTest.resetDb();
        super.setUp();
    }

    @Override
    protected JDBCConnectOptions connectOptions() {
        return options;
    }

    @Test
    public void testCanReadEnum(TestContext should) {
        SqlTemplate.forQuery((SqlClient)this.client, (String)"SELECT id, status FROM my_objects WHERE id = #{id}").mapTo((RowMapper)MyObjectRowMapper.INSTANCE).execute(Collections.singletonMap("id", 1), should.asyncAssertSuccess(rows -> {
            should.assertEquals((Object)1, (Object)rows.size());
            should.assertEquals((Object)MyObject.Status.ABC, (Object)((MyObject)rows.iterator().next()).getType());
        }));
    }

    static {
        SQL.add("drop table if exists my_objects");
        SQL.add("create table my_objects (id int, status varchar(255) );");
        SQL.add("insert into my_objects values (1, 'ABC');");
    }
}

