/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.jdbcclient.FetchDirection;
import io.vertx.jdbcclient.JDBCConnectOptionsConverter;
import io.vertx.jdbcclient.ResultSetConcurrency;
import io.vertx.jdbcclient.ResultSetType;
import io.vertx.jdbcclient.SqlOptions;
import io.vertx.jdbcclient.TransactionIsolation;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class JDBCConnectOptions
extends SqlOptions {
    private String jdbcUrl;
    private String user;
    private String password;
    private String database;
    private int connectTimeout = 60000;
    private int idleTimeout;
    private TracingPolicy tracingPolicy = TracingPolicy.PROPAGATE;
    private JsonObject extraConfig;
    private String metricsName = "";

    public JDBCConnectOptions() {
    }

    public JDBCConnectOptions(JsonObject json) {
        JDBCConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JDBCConnectOptions(JDBCConnectOptions other) {
        super(other);
        this.jdbcUrl = other.jdbcUrl;
        this.user = other.user;
        this.password = other.password;
        this.database = other.database;
        this.connectTimeout = other.connectTimeout;
        this.idleTimeout = other.idleTimeout;
        this.tracingPolicy = other.tracingPolicy;
        this.extraConfig = other.extraConfig != null ? other.extraConfig.copy() : null;
        this.metricsName = other.metricsName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public JDBCConnectOptions setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public JDBCConnectOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public JDBCConnectOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public JDBCConnectOptions setDatabase(String database) {
        this.database = database;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public JDBCConnectOptions setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public JDBCConnectOptions setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public JDBCConnectOptions setMetricsName(String metricsName) {
        this.metricsName = metricsName;
        return this;
    }

    public TracingPolicy getTracingPolicy() {
        return this.tracingPolicy;
    }

    public JDBCConnectOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        this.tracingPolicy = tracingPolicy;
        return this;
    }

    public JsonObject getExtraConfig() {
        return this.extraConfig;
    }

    public JDBCConnectOptions setExtraConfig(JsonObject extraConfig) {
        this.extraConfig = extraConfig;
        return this;
    }

    @Override
    public JDBCConnectOptions setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public JDBCConnectOptions setCatalog(String catalog) {
        super.setCatalog(catalog);
        return this;
    }

    @Override
    public JDBCConnectOptions setTransactionIsolation(TransactionIsolation transactionIsolation) {
        super.setTransactionIsolation(transactionIsolation);
        return this;
    }

    @Override
    public JDBCConnectOptions setResultSetType(ResultSetType resultSetType) {
        super.setResultSetType(resultSetType);
        return this;
    }

    @Override
    public JDBCConnectOptions setResultSetConcurrency(ResultSetConcurrency resultSetConcurrency) {
        super.setResultSetConcurrency(resultSetConcurrency);
        return this;
    }

    @Override
    public JDBCConnectOptions setAutoGeneratedKeys(boolean autoGeneratedKeys) {
        super.setAutoGeneratedKeys(autoGeneratedKeys);
        return this;
    }

    @Override
    public JDBCConnectOptions setSchema(String schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public JDBCConnectOptions setQueryTimeout(int queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public JDBCConnectOptions setFetchDirection(FetchDirection fetchDirection) {
        super.setFetchDirection(fetchDirection);
        return this;
    }

    @Override
    public JDBCConnectOptions setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public JDBCConnectOptions setAutoGeneratedKeysIndexes(JsonArray autoGeneratedKeysIndexes) {
        super.setAutoGeneratedKeysIndexes(autoGeneratedKeysIndexes);
        return this;
    }

    @Override
    public JDBCConnectOptions setMaxRows(int maxRows) {
        super.setMaxRows(maxRows);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JDBCConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

