/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

public enum TransactionIsolation {
    READ_UNCOMMITTED(1),
    READ_COMMITTED(2),
    REPEATABLE_READ(4),
    SERIALIZABLE(8),
    NONE(0);

    private final int type;

    private TransactionIsolation(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static TransactionIsolation from(int level) {
        switch (level) {
            case 2: {
                return READ_COMMITTED;
            }
            case 1: {
                return READ_UNCOMMITTED;
            }
            case 4: {
                return REPEATABLE_READ;
            }
            case 8: {
                return SERIALIZABLE;
            }
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    public static TransactionIsolation from(String level) {
        if (level != null) {
            switch (level.replace('-', ' ').toUpperCase()) {
                case "READ COMMITTED": {
                    return READ_COMMITTED;
                }
                case "READ UNCOMMITTED": {
                    return READ_UNCOMMITTED;
                }
                case "REPEATABLE READ": {
                    return REPEATABLE_READ;
                }
                case "SERIALIZABLE": {
                    return SERIALIZABLE;
                }
                case "NONE": {
                    return NONE;
                }
            }
        }
        return null;
    }
}

