/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.json.JsonArray;
import io.vertx.jdbcclient.FetchDirection;
import io.vertx.jdbcclient.ResultSetConcurrency;
import io.vertx.jdbcclient.ResultSetType;
import io.vertx.jdbcclient.TransactionIsolation;

public class SqlOptions {
    private boolean readOnly;
    private String catalog;
    private TransactionIsolation transactionIsolation;
    private ResultSetType resultSetType;
    private ResultSetConcurrency resultSetConcurrency;
    private boolean autoGeneratedKeys = true;
    private JsonArray autoGeneratedKeysIndexes;
    private String schema;
    private int queryTimeout;
    private int maxRows;
    private FetchDirection fetchDirection;
    private int fetchSize;

    public SqlOptions() {
    }

    public SqlOptions(SqlOptions other) {
        this.readOnly = other.isReadOnly();
        this.catalog = other.getCatalog();
        this.transactionIsolation = other.getTransactionIsolation();
        this.resultSetType = other.getResultSetType();
        this.resultSetConcurrency = other.getResultSetConcurrency();
        this.autoGeneratedKeys = other.isAutoGeneratedKeys();
        this.autoGeneratedKeysIndexes = other.getAutoGeneratedKeysIndexes();
        this.schema = other.getSchema();
        this.queryTimeout = other.getQueryTimeout();
        this.fetchDirection = other.getFetchDirection();
        this.fetchSize = other.getFetchSize();
        this.maxRows = other.getMaxRows();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public SqlOptions setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public SqlOptions setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public SqlOptions setTransactionIsolation(TransactionIsolation transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
        return this;
    }

    public ResultSetType getResultSetType() {
        return this.resultSetType;
    }

    public SqlOptions setResultSetType(ResultSetType resultSetType) {
        this.resultSetType = resultSetType;
        return this;
    }

    public ResultSetConcurrency getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public SqlOptions setResultSetConcurrency(ResultSetConcurrency resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
        return this;
    }

    public boolean isAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public SqlOptions setAutoGeneratedKeys(boolean autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public SqlOptions setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public SqlOptions setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public FetchDirection getFetchDirection() {
        return this.fetchDirection;
    }

    public SqlOptions setFetchDirection(FetchDirection fetchDirection) {
        this.fetchDirection = fetchDirection;
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public SqlOptions setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JsonArray getAutoGeneratedKeysIndexes() {
        return this.autoGeneratedKeysIndexes;
    }

    public SqlOptions setAutoGeneratedKeysIndexes(JsonArray autoGeneratedKeysIndexes) {
        this.autoGeneratedKeysIndexes = autoGeneratedKeysIndexes;
        return this;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public SqlOptions setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }
}

