/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.SqlOptions;
import io.vertx.jdbcclient.impl.ConnectionImpl;
import io.vertx.jdbcclient.impl.FakeDriver;
import io.vertx.jdbcclient.impl.actions.JDBCStatementHelper;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.internal.SqlConnectionBase;
import io.vertx.sqlclient.internal.pool.CloseablePool;
import io.vertx.sqlclient.internal.pool.PoolImpl;
import io.vertx.sqlclient.spi.Driver;
import java.sql.Connection;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCPoolImpl {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.jdbcclient";

    public static Pool newPool(Vertx vertx, JDBCConnectOptions connectOptions, PoolOptions poolOptions, Callable<Connection> connectionSupplier) {
        CloseFuture closeFuture = new CloseFuture();
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = poolOptions.isShared() ? (PoolImpl)vx.createSharedResource(SHARED_CLIENT_KEY, poolOptions.getName(), closeFuture, cf -> JDBCPoolImpl.newPoolImpl((Vertx)vx, connectOptions, poolOptions, connectionSupplier, cf)) : JDBCPoolImpl.newPoolImpl((Vertx)vx, connectOptions, poolOptions, connectionSupplier, closeFuture);
        CloseablePool closeablePool = new CloseablePool(vx, closeFuture, (Pool)pool);
        ContextInternal ctx = vx.getContext();
        if (ctx != null) {
            ctx.addCloseHook((Closeable)closeFuture);
        } else {
            vx.addCloseHook((Closeable)closeFuture);
        }
        return closeablePool;
    }

    private static PoolImpl newPoolImpl(Vertx vertx, JDBCConnectOptions connectOptions, PoolOptions poolOptions, Callable<Connection> connectionFactory, CloseFuture closeFuture) {
        PoolImpl pool = new PoolImpl((VertxInternal)vertx, (Driver)FakeDriver.INSTANCE, false, poolOptions, conn -> {
            ConnectionImpl jdbc = (ConnectionImpl)conn.unwrap();
            jdbc.sqlOptions = new SqlOptions(connectOptions);
            return Future.succeededFuture();
        }, conn -> {
            Future voidFuture = Future.succeededFuture();
            ConnectionImpl jdbc = (ConnectionImpl)conn.unwrap();
            jdbc.sqlOptions = null;
            return voidFuture;
        }, ctx -> new ConnectionFactory((VertxInternal)vertx, connectOptions, connectionFactory).connect((ContextInternal)ctx), null, closeFuture);
        pool.init();
        return pool;
    }

    private static class ConnectionFactory {
        private static final String NET_LOCATION_REGEX = "(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)";
        private static final String PORT_REGEX = "(:(?<port>\\d+))?";
        private static final Pattern HOST_AND_PORT_PATTERN = Pattern.compile("://(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)(:(?<port>\\d+))?");
        private final VertxInternal vertx;
        private final JDBCConnectOptions sqlOptions;
        private final Callable<Connection> connectionFactory;

        public ConnectionFactory(VertxInternal vertx, JDBCConnectOptions sqlOptions, Callable<Connection> connectionFactory) {
            this.vertx = vertx;
            this.sqlOptions = sqlOptions;
            this.connectionFactory = connectionFactory;
        }

        private SocketAddress getServer(Connection conn) throws Exception {
            String url = conn.getMetaData().getURL();
            Matcher match = HOST_AND_PORT_PATTERN.matcher(url);
            if (match.find()) {
                String portString;
                String host = ConnectionFactory.parseNetLocation(match.group("netloc"));
                int port = match.groupCount() > 1 && (portString = match.group("port")) != null && portString.length() > 0 ? Integer.parseInt(portString) : 0;
                return SocketAddress.inetSocketAddress((int)port, (String)host);
            }
            return SocketAddress.inetSocketAddress((int)1234, (String)"unknown");
        }

        private static String parseNetLocation(String host) {
            if (ConnectionFactory.isRegardedAsIpv6Address(host)) {
                return host.substring(1, host.length() - 1);
            }
            return host;
        }

        private static boolean isRegardedAsIpv6Address(String address) {
            return address.startsWith("[") && address.endsWith("]");
        }

        public Future<SqlConnection> connect(ContextInternal context) {
            JsonObject cfg = this.sqlOptions.getExtraConfig();
            if (cfg == null) {
                cfg = new JsonObject();
            }
            JDBCStatementHelper helper = new JDBCStatementHelper(cfg);
            return context.executeBlockingInternal(() -> {
                Connection conn = this.connectionFactory.call();
                VertxMetrics vertxMetrics = this.vertx.metrics();
                SocketAddress server = this.getServer(conn);
                ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(server, "sql", this.sqlOptions.getMetricsName()) : null;
                return new SqlConnectionBase(context, null, (io.vertx.sqlclient.internal.Connection)new ConnectionImpl(helper, context, this.sqlOptions, conn, metrics, this.sqlOptions.getUser(), this.sqlOptions.getDatabase(), server), (Driver)FakeDriver.INSTANCE);
            });
        }
    }
}

