/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.json.JsonObject;
import io.vertx.jdbcclient.spi.JDBCDecoder;
import io.vertx.jdbcclient.spi.JDBCDecoderImpl;
import io.vertx.jdbcclient.spi.JDBCEncoder;
import io.vertx.jdbcclient.spi.JDBCEncoderImpl;
import java.util.Arrays;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.regex.Pattern;

public final class JDBCStatementHelper {
    public static final Pattern UUID = Pattern.compile("^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$");
    private final JDBCEncoder encoder;
    private final JDBCDecoder decoder;

    public JDBCStatementHelper() {
        this(new JsonObject());
    }

    public JDBCStatementHelper(JsonObject config) {
        this.encoder = this.initEncoder(config);
        this.decoder = this.initDecoder(config);
    }

    private JDBCEncoder initEncoder(JsonObject config) {
        JDBCEncoder encoder = (JDBCEncoder)JDBCStatementHelper.initObject(config.getString("encoderCls"));
        if (encoder == null) {
            ServiceLoader<JDBCEncoder> loader = ServiceLoader.load(JDBCEncoder.class);
            encoder = loader.findFirst().orElseGet(JDBCEncoderImpl::new);
        }
        return encoder;
    }

    private JDBCDecoder initDecoder(JsonObject config) {
        JDBCDecoder decoder = (JDBCDecoder)JDBCStatementHelper.initObject(config.getString("decoderCls"));
        if (decoder == null) {
            ServiceLoader<JDBCDecoder> loader = ServiceLoader.load(JDBCDecoder.class);
            decoder = loader.findFirst().orElseGet(JDBCDecoderImpl::new);
        }
        return decoder;
    }

    public JDBCEncoder getEncoder() {
        return this.encoder;
    }

    public JDBCDecoder getDecoder() {
        return this.decoder;
    }

    private static <T> T initObject(String clsName) {
        Class<T> cls = JDBCStatementHelper.findClass(clsName);
        if (cls == null) {
            return null;
        }
        try {
            return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate " + cls.getName(), e);
        }
    }

    private static <T> Class<T> findClass(String cls) {
        if (Objects.isNull(cls)) {
            return null;
        }
        for (ClassLoader classLoader : Arrays.asList(Thread.currentThread().getContextClassLoader(), JDBCStatementHelper.class.getClassLoader())) {
            try {
                return Class.forName(cls, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }
}

