/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.jdbcclient.impl.actions.JDBCRowDesc;
import io.vertx.jdbcclient.spi.JDBCColumnDescriptorProvider;
import io.vertx.sqlclient.internal.ParamDesc;
import io.vertx.sqlclient.internal.PreparedStatement;
import io.vertx.sqlclient.internal.RowDesc;
import io.vertx.sqlclient.internal.TupleInternal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JDBCPreparedStatement
implements PreparedStatement {
    private final String sql;
    private final java.sql.PreparedStatement preparedStatement;
    private final RowDesc rowDesc;
    private final ParamDesc paramDesc;

    public JDBCPreparedStatement(String sql, java.sql.PreparedStatement preparedStatement) throws SQLException {
        JDBCRowDesc rowDesc;
        ResultSetMetaData metaData = preparedStatement.getMetaData();
        if (metaData != null) {
            int cols = metaData.getColumnCount();
            JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromResultMetaData(metaData);
            rowDesc = new JDBCRowDesc(provider, cols);
        } else {
            rowDesc = new JDBCRowDesc();
        }
        this.sql = sql;
        this.rowDesc = rowDesc;
        this.paramDesc = new ParamDesc();
        this.preparedStatement = preparedStatement;
    }

    public java.sql.PreparedStatement preparedStatement() {
        return this.preparedStatement;
    }

    public ParamDesc paramDesc() {
        return this.paramDesc;
    }

    public RowDesc rowDesc() {
        return this.rowDesc;
    }

    public String sql() {
        return this.sql;
    }

    public TupleInternal prepare(TupleInternal values) {
        return values;
    }
}

