/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.jdbcclient.SqlOptions;
import io.vertx.jdbcclient.impl.JDBCRow;
import io.vertx.jdbcclient.impl.actions.AbstractJDBCAction;
import io.vertx.jdbcclient.impl.actions.CachedParameterMetaData;
import io.vertx.jdbcclient.impl.actions.CallableOutParams;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.jdbcclient.impl.actions.JDBCRowDesc;
import io.vertx.jdbcclient.impl.actions.JDBCStatementHelper;
import io.vertx.jdbcclient.spi.JDBCColumnDescriptorProvider;
import io.vertx.jdbcclient.spi.JDBCDecoder;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class JDBCQueryAction<C, R>
extends AbstractJDBCAction<JDBCResponse<R>> {
    private final Collector<Row, C, R> collector;

    public JDBCQueryAction(JDBCStatementHelper helper, SqlOptions options, Collector<Row, C, R> collector) {
        super(helper, options);
        this.collector = collector;
    }

    protected JDBCResponse<R> decode(Statement statement, boolean returnedResultSet, boolean returnedKeys, CallableOutParams outParams) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(statement.getUpdateCount());
        if (returnedResultSet) {
            while (returnedResultSet) {
                try (ResultSet rs = statement.getResultSet();){
                    this.decodeResultSet(rs, response);
                    if (returnedKeys) {
                        this.decodeReturnedKeys(statement, response);
                    }
                }
                returnedResultSet = statement.getMoreResults();
            }
        } else {
            this.collector.accumulator();
            C container = this.collector.supplier().get();
            response.empty(this.collector.finisher().apply(container));
            if (returnedKeys) {
                this.decodeReturnedKeys(statement, response);
            }
        }
        if (!outParams.isEmpty()) {
            this.decodeOutput((CallableStatement)statement, outParams, response);
        }
        return response;
    }

    protected JDBCResponse<R> decode(Statement statement, int[] returnedBatchResult, boolean returnedKeys) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(returnedBatchResult.length);
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        JDBCRowDesc desc = new JDBCRowDesc(new ColumnDescriptor[0]);
        C container = this.collector.supplier().get();
        for (int result : returnedBatchResult) {
            JDBCRow row = new JDBCRow(desc);
            row.addValue(result);
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, returnedBatchResult.length);
        if (returnedBatchResult.length != 0 && returnedKeys) {
            this.decodeReturnedKeys(statement, response);
        }
        return response;
    }

    private void decodeResultSet(ResultSet rs, JDBCResponse<R> response) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ResultSetMetaData metaData = rs.getMetaData();
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromResultMetaData(metaData);
        JDBCRowDesc desc = new JDBCRowDesc(provider, metaData.getColumnCount());
        C container = this.collector.supplier().get();
        int size = 0;
        while (rs.next()) {
            ++size;
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= desc.columnDescriptor().size(); ++i) {
                row.addValue(this.helper.getDecoder().parse(rs, i, provider));
            }
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, size);
    }

    private R decodeRawResultSet(ResultSet rs) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ResultSetMetaData metaData = rs.getMetaData();
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromResultMetaData(metaData);
        int cols = metaData.getColumnCount();
        JDBCRowDesc desc = new JDBCRowDesc(provider, cols);
        C container = this.collector.supplier().get();
        while (rs.next()) {
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= cols; ++i) {
                row.addValue(this.helper.getDecoder().parse(rs, i, provider));
            }
            accumulator.accept(container, row);
        }
        return this.collector.finisher().apply(container);
    }

    private void decodeOutput(CallableStatement cs, CallableOutParams outParams, JDBCResponse<R> output) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        C container = this.collector.supplier().get();
        ParameterMetaData md = new CachedParameterMetaData(cs).putOutParams(outParams);
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromParameterMetaData(md);
        JDBCRowDesc desc = new JDBCRowDesc(provider, outParams.size());
        JDBCRow row = new JDBCRow(desc);
        JDBCDecoder decoder = this.helper.getDecoder();
        for (Integer idx : outParams.keySet()) {
            Object o = cs.getObject(idx);
            if (o instanceof ResultSet) {
                row.addValue(this.decodeRawResultSet((ResultSet)o));
                continue;
            }
            row.addValue(decoder.parse(cs, (int)idx, provider));
        }
        accumulator.accept(container, row);
        R result = this.collector.finisher().apply(container);
        output.outputs(result, desc, 1);
    }

    private void decodeReturnedKeys(Statement statement, JDBCResponse<R> response) throws SQLException {
        ResultSetMetaData metaData;
        JDBCRow keys = null;
        ResultSet keysRS = statement.getGeneratedKeys();
        if (keysRS != null && keysRS.next() && (metaData = keysRS.getMetaData()) != null) {
            JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromResultMetaData(metaData);
            int cols = metaData.getColumnCount();
            if (cols > 0) {
                JDBCRowDesc keysDesc = new JDBCRowDesc(provider, cols);
                keys = new JDBCRow(keysDesc);
                for (int i = 1; i <= cols; ++i) {
                    keys.addValue(this.helper.getDecoder().parse(keysRS, i, provider));
                }
            }
            response.returnedKeys(keys);
        }
    }

    boolean returnAutoGeneratedKeys(Connection conn) {
        boolean autoGeneratedIndexes;
        boolean autoGeneratedKeys = this.options == null || this.options.isAutoGeneratedKeys();
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null && this.options.getAutoGeneratedKeysIndexes().size() > 0;
        if (autoGeneratedKeys || autoGeneratedIndexes) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd != null) {
                    return dbmd.supportsGetGeneratedKeys();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }
}

