package io.vertx.jdbcclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.jdbcclient.JDBCConnectOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.jdbcclient.JDBCConnectOptions} original class using Vert.x codegen.
 */
public class JDBCConnectOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, JDBCConnectOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "readOnly":
          if (member.getValue() instanceof Boolean) {
            obj.setReadOnly((Boolean)member.getValue());
          }
          break;
        case "catalog":
          if (member.getValue() instanceof String) {
            obj.setCatalog((String)member.getValue());
          }
          break;
        case "transactionIsolation":
          if (member.getValue() instanceof String) {
            obj.setTransactionIsolation(io.vertx.jdbcclient.TransactionIsolation.valueOf((String)member.getValue()));
          }
          break;
        case "resultSetType":
          if (member.getValue() instanceof String) {
            obj.setResultSetType(io.vertx.jdbcclient.ResultSetType.valueOf((String)member.getValue()));
          }
          break;
        case "resultSetConcurrency":
          if (member.getValue() instanceof String) {
            obj.setResultSetConcurrency(io.vertx.jdbcclient.ResultSetConcurrency.valueOf((String)member.getValue()));
          }
          break;
        case "autoGeneratedKeys":
          if (member.getValue() instanceof Boolean) {
            obj.setAutoGeneratedKeys((Boolean)member.getValue());
          }
          break;
        case "schema":
          if (member.getValue() instanceof String) {
            obj.setSchema((String)member.getValue());
          }
          break;
        case "queryTimeout":
          if (member.getValue() instanceof Number) {
            obj.setQueryTimeout(((Number)member.getValue()).intValue());
          }
          break;
        case "fetchDirection":
          if (member.getValue() instanceof String) {
            obj.setFetchDirection(io.vertx.jdbcclient.FetchDirection.valueOf((String)member.getValue()));
          }
          break;
        case "fetchSize":
          if (member.getValue() instanceof Number) {
            obj.setFetchSize(((Number)member.getValue()).intValue());
          }
          break;
        case "autoGeneratedKeysIndexes":
          if (member.getValue() instanceof JsonArray) {
            obj.setAutoGeneratedKeysIndexes(((JsonArray)member.getValue()).copy());
          }
          break;
        case "maxRows":
          if (member.getValue() instanceof Number) {
            obj.setMaxRows(((Number)member.getValue()).intValue());
          }
          break;
        case "jdbcUrl":
          if (member.getValue() instanceof String) {
            obj.setJdbcUrl((String)member.getValue());
          }
          break;
        case "user":
          if (member.getValue() instanceof String) {
            obj.setUser((String)member.getValue());
          }
          break;
        case "password":
          if (member.getValue() instanceof String) {
            obj.setPassword((String)member.getValue());
          }
          break;
        case "database":
          if (member.getValue() instanceof String) {
            obj.setDatabase((String)member.getValue());
          }
          break;
        case "connectTimeout":
          if (member.getValue() instanceof Number) {
            obj.setConnectTimeout(((Number)member.getValue()).intValue());
          }
          break;
        case "idleTimeout":
          if (member.getValue() instanceof Number) {
            obj.setIdleTimeout(((Number)member.getValue()).intValue());
          }
          break;
        case "metricsName":
          if (member.getValue() instanceof String) {
            obj.setMetricsName((String)member.getValue());
          }
          break;
        case "tracingPolicy":
          if (member.getValue() instanceof String) {
            obj.setTracingPolicy(io.vertx.core.tracing.TracingPolicy.valueOf((String)member.getValue()));
          }
          break;
        case "extraConfig":
          if (member.getValue() instanceof JsonObject) {
            obj.setExtraConfig(((JsonObject)member.getValue()).copy());
          }
          break;
      }
    }
  }

   static void toJson(JDBCConnectOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(JDBCConnectOptions obj, java.util.Map<String, Object> json) {
    json.put("readOnly", obj.isReadOnly());
    if (obj.getCatalog() != null) {
      json.put("catalog", obj.getCatalog());
    }
    if (obj.getTransactionIsolation() != null) {
      json.put("transactionIsolation", obj.getTransactionIsolation().name());
    }
    if (obj.getResultSetType() != null) {
      json.put("resultSetType", obj.getResultSetType().name());
    }
    if (obj.getResultSetConcurrency() != null) {
      json.put("resultSetConcurrency", obj.getResultSetConcurrency().name());
    }
    json.put("autoGeneratedKeys", obj.isAutoGeneratedKeys());
    if (obj.getSchema() != null) {
      json.put("schema", obj.getSchema());
    }
    json.put("queryTimeout", obj.getQueryTimeout());
    if (obj.getFetchDirection() != null) {
      json.put("fetchDirection", obj.getFetchDirection().name());
    }
    json.put("fetchSize", obj.getFetchSize());
    if (obj.getAutoGeneratedKeysIndexes() != null) {
      json.put("autoGeneratedKeysIndexes", obj.getAutoGeneratedKeysIndexes());
    }
    json.put("maxRows", obj.getMaxRows());
    if (obj.getJdbcUrl() != null) {
      json.put("jdbcUrl", obj.getJdbcUrl());
    }
    if (obj.getUser() != null) {
      json.put("user", obj.getUser());
    }
    if (obj.getPassword() != null) {
      json.put("password", obj.getPassword());
    }
    if (obj.getDatabase() != null) {
      json.put("database", obj.getDatabase());
    }
    json.put("connectTimeout", obj.getConnectTimeout());
    json.put("idleTimeout", obj.getIdleTimeout());
    if (obj.getMetricsName() != null) {
      json.put("metricsName", obj.getMetricsName());
    }
    if (obj.getTracingPolicy() != null) {
      json.put("tracingPolicy", obj.getTracingPolicy().name());
    }
    if (obj.getExtraConfig() != null) {
      json.put("extraConfig", obj.getExtraConfig());
    }
  }
}
