/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.impl.JDBCPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.Row;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

@VertxGen
public interface JDBCPool
extends Pool {
    public static final PropertyKind<Row> GENERATED_KEYS = PropertyKind.create((String)"generated-keys", Row.class);
    public static final PropertyKind<Boolean> OUTPUT = PropertyKind.create((String)"callable-statement-output", Boolean.class);

    public static Pool pool(Vertx vertx, JDBCConnectOptions connectOptions, PoolOptions poolOptions) {
        Callable<Connection> connectionCallable = () -> DriverManager.getConnection(connectOptions.getJdbcUrl(), connectOptions.getUser(), connectOptions.getPassword());
        return JDBCPoolImpl.newPool(vertx, connectOptions, poolOptions, connectionCallable);
    }

    @GenIgnore(value={"permitted-type"})
    public static Pool pool(Vertx vertx, DataSource dataSource, PoolOptions poolOptions) {
        return JDBCPoolImpl.newPool(vertx, new JDBCConnectOptions(), poolOptions, () -> dataSource.getConnection());
    }
}

