/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.common.SchemaRouterImpl;
import java.net.URI;
import java.util.List;

@VertxGen
public interface SchemaRouter {
    public @Nullable Schema resolveCachedSchema(JsonPointer var1, JsonPointer var2, SchemaParser var3) throws SchemaException;

    public void resolveRef(JsonPointer var1, JsonPointer var2, SchemaParser var3, Handler<AsyncResult<Schema>> var4);

    public Future<Schema> resolveRef(JsonPointer var1, JsonPointer var2, SchemaParser var3);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public SchemaRouter addSchema(Schema var1, JsonPointer ... var2);

    @Fluent
    public SchemaRouter addSchemaWithScope(Schema var1, JsonPointer var2);

    @Fluent
    public SchemaRouter addSchemaAlias(Schema var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public SchemaRouter addJson(URI var1, JsonObject var2);

    @Fluent
    default public SchemaRouter addJson(String uri, JsonObject object) {
        return this.addJson(URI.create(uri), object);
    }

    public List<Schema> registeredSchemas();

    public static SchemaRouter create(Vertx vertx, SchemaRouterOptions schemaRouterOptions) {
        return new SchemaRouterImpl(vertx.createHttpClient(), vertx.fileSystem(), schemaRouterOptions);
    }

    public static SchemaRouter create(HttpClient client, FileSystem fs, SchemaRouterOptions schemaRouterOptions) {
        return new SchemaRouterImpl(client, fs, schemaRouterOptions);
    }
}

