/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;

public class MaxLengthValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Number maximum = (Number)schema.getValue("maxLength");
            if (maximum.intValue() < 0) {
                throw new SchemaException(schema, "maxLength must be >= 0");
            }
            return new MaxLengthValidator(maximum.intValue());
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for maxLength keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null maxLength keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("maxLength");
    }

    public class MaxLengthValidator
    extends BaseSyncValidator {
        private final int maximum;

        public MaxLengthValidator(int maximum) {
            this.maximum = maximum;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (in instanceof String && ((String)in).codePointCount(0, ((String)in).length()) > this.maximum) {
                throw ValidationException.createException("provided string should have size <= " + this.maximum, "maxLength", in);
            }
        }
    }
}

