/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;

public class MinPropertiesValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Number minimum = (Number)schema.getValue("minProperties");
            if (minimum.intValue() < 0) {
                throw new SchemaException(schema, "minProperties must be >= 0");
            }
            return new MinPropertiesValidator(minimum.intValue());
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for minProperties keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null minProperties keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("minProperties");
    }

    public class MinPropertiesValidator
    extends BaseSyncValidator {
        private final int minimum;

        public MinPropertiesValidator(int minimum) {
            this.minimum = minimum;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (in instanceof JsonObject && ((JsonObject)in).size() < this.minimum) {
                throw ValidationException.createException("provided object should have size >= " + this.minimum, "minProperties", in);
            }
        }
    }
}

