/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft201909;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseMutableStateValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DependentSchemasValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            JsonObject dependencies = schema.getJsonObject("dependentSchemas");
            JsonPointer baseScope = scope.copy().append("dependentSchemas");
            DependentSchemasValidator validator = new DependentSchemasValidator(parent);
            validator.configure(dependencies.stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> parser.parse(entry.getValue(), baseScope.copy().append((String)entry.getKey()), (MutableStateValidator)validator))));
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for dependentSchemas keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null dependentSchemas keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("dependentSchemas");
    }

    class DependentSchemasValidator
    extends BaseMutableStateValidator {
        Map<String, SchemaInternal> keySchemaDeps;

        public DependentSchemasValidator(MutableStateValidator parent) {
            super(parent);
        }

        private void configure(Map<String, SchemaInternal> keySchemaDeps) {
            this.keySchemaDeps = keySchemaDeps;
            this.initializeIsSync();
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            if (in instanceof JsonObject) {
                JsonObject obj = (JsonObject)in;
                List futs = this.keySchemaDeps.entrySet().stream().filter(e -> obj.containsKey((String)e.getKey())).map(e -> ((SchemaInternal)e.getValue()).validateAsync(context, in)).collect(Collectors.toList());
                if (futs.isEmpty()) {
                    return Future.succeededFuture();
                }
                return CompositeFuture.all(futs).mapEmpty();
            }
            return Future.succeededFuture();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            if (in instanceof JsonObject) {
                JsonObject obj = (JsonObject)in;
                this.keySchemaDeps.entrySet().stream().filter(e -> obj.containsKey((String)e.getKey())).forEach(e -> ((SchemaInternal)e.getValue()).validateSync(context, in));
            }
        }

        @Override
        public boolean calculateIsSync() {
            return this.keySchemaDeps.values().stream().map(Schema::isSync).reduce(true, Boolean::logicalAnd);
        }
    }
}

