/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft7;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseMutableStateValidator;
import io.vertx.json.schema.common.DefaultApplier;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaImpl;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.ArrayList;
import java.util.Arrays;

public class ItemsValidatorFactory
extends io.vertx.json.schema.common.ItemsValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        Object itemsSchema = schema.getValue("items");
        if (itemsSchema instanceof JsonArray) {
            try {
                JsonPointer baseScope = scope.copy().append("items");
                JsonArray itemsList = (JsonArray)itemsSchema;
                ArrayList<SchemaInternal> parsedSchemas = new ArrayList<SchemaInternal>();
                ItemByItemValidator validator = new ItemByItemValidator(parent);
                for (int i = 0; i < itemsList.size(); ++i) {
                    parsedSchemas.add(i, parser.parse(itemsList.getValue(i), baseScope.copy().append(Integer.toString(i)), (MutableStateValidator)validator));
                }
                if (schema.containsKey("additionalItems")) {
                    validator.configure(parsedSchemas.toArray(new SchemaInternal[parsedSchemas.size()]), parser.parse(schema.getValue("additionalItems"), scope.copy().append("additionalItems"), (MutableStateValidator)validator));
                } else {
                    validator.configure(parsedSchemas.toArray(new SchemaInternal[parsedSchemas.size()]), null);
                }
                return validator;
            }
            catch (NullPointerException e) {
                throw new SchemaException(schema, "Null items keyword", e);
            }
        }
        return super.createValidator(schema, scope, parser, parent);
    }

    class ItemByItemValidator
    extends BaseMutableStateValidator
    implements DefaultApplier {
        SchemaInternal[] schemas;
        SchemaInternal additionalItems;

        public ItemByItemValidator(MutableStateValidator parent) {
            super(parent);
        }

        private void configure(SchemaInternal[] schemas, SchemaInternal additionalItems) {
            this.schemas = schemas;
            this.additionalItems = additionalItems;
            this.initializeIsSync();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            if (in instanceof JsonArray) {
                JsonArray arr = (JsonArray)in;
                for (int i = 0; i < arr.size(); ++i) {
                    if (i >= this.schemas.length) {
                        if (this.additionalItems == null) continue;
                        context.markEvaluatedItem(i);
                        this.additionalItems.validateSync(context.lowerLevelContext(), arr.getValue(i));
                        continue;
                    }
                    context.markEvaluatedItem(i);
                    this.schemas[i].validateSync(context.lowerLevelContext(), arr.getValue(i));
                }
            }
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            if (in instanceof JsonArray) {
                ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
                JsonArray arr = (JsonArray)in;
                for (int i = 0; i < arr.size(); ++i) {
                    Future<Void> fut;
                    if (i >= this.schemas.length) {
                        if (this.additionalItems == null) continue;
                        context.markEvaluatedItem(i);
                        fut = this.additionalItems.validateAsync(context.lowerLevelContext(), arr.getValue(i));
                    } else {
                        context.markEvaluatedItem(i);
                        fut = this.schemas[i].validateAsync(context.lowerLevelContext(), arr.getValue(i));
                    }
                    if (fut.isComplete()) {
                        if (!fut.failed()) continue;
                        return Future.failedFuture((Throwable)fut.cause());
                    }
                    futures.add(fut);
                }
                if (futures.isEmpty()) {
                    return Future.succeededFuture();
                }
                return CompositeFuture.all(futures).compose(cf -> Future.succeededFuture());
            }
            return Future.succeededFuture();
        }

        @Override
        public boolean calculateIsSync() {
            return (this.additionalItems == null || this.additionalItems.isSync()) && Arrays.stream(this.schemas).map(Schema::isSync).reduce(true, Boolean::logicalAnd) != false;
        }

        @Override
        public void applyDefaultValue(Object value) {
            if (value instanceof JsonArray) {
                JsonArray arr = (JsonArray)value;
                for (int i = 0; i < arr.size(); ++i) {
                    if (i >= this.schemas.length) {
                        if (this.additionalItems == null) continue;
                        ((SchemaImpl)this.additionalItems).doApplyDefaultValues(arr.getValue(i));
                        continue;
                    }
                    ((SchemaImpl)this.schemas[i]).doApplyDefaultValues(arr.getValue(i));
                }
            }
        }
    }
}

