/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft7;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.JsonSchemaType;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.common.ValidatorPriority;
import java.util.ArrayList;
import java.util.Arrays;

public class TypeValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            ArrayList<JsonSchemaType> allowedTypes = new ArrayList<JsonSchemaType>();
            Object type = schema.getValue("type");
            String format = schema.getString("format");
            if (type instanceof String) {
                allowedTypes.add(TypeValidatorFactory.parseType((String)type, format, schema));
            } else {
                JsonArray types = (JsonArray)type;
                for (Object t : types) {
                    allowedTypes.add(TypeValidatorFactory.parseType((String)t, format, schema));
                }
            }
            boolean allowNull = allowedTypes.contains((Object)JsonSchemaType.NULL);
            if (allowNull) {
                allowedTypes.remove((Object)JsonSchemaType.NULL);
            }
            return new TypeValidator(allowedTypes.toArray(new JsonSchemaType[allowedTypes.size()]), allowNull);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null type keyword", e);
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for type or format keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("type");
    }

    private static JsonSchemaType parseType(String type, String format, JsonObject schema) {
        switch (type) {
            case "integer": {
                return JsonSchemaType.INTEGER;
            }
            case "number": {
                return format != null && (format.equals("double") || format.equals("float")) ? JsonSchemaType.NUMBER_DECIMAL : JsonSchemaType.NUMBER;
            }
            case "boolean": {
                return JsonSchemaType.BOOLEAN;
            }
            case "string": {
                return JsonSchemaType.STRING;
            }
            case "object": {
                return JsonSchemaType.OBJECT;
            }
            case "array": {
                return JsonSchemaType.ARRAY;
            }
            case "null": {
                return JsonSchemaType.NULL;
            }
        }
        throw new SchemaException(schema, "Unknown type: " + type);
    }

    class TypeValidator
    extends BaseSyncValidator {
        final JsonSchemaType[] types;
        final boolean nullIsValid;

        public TypeValidator(JsonSchemaType[] types, boolean nullIsValid) {
            this.types = types;
            this.nullIsValid = nullIsValid;
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.MAX_PRIORITY;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (in != null) {
                for (JsonSchemaType type : this.types) {
                    if (!type.checkInstance(in)) continue;
                    return;
                }
                throw ValidationException.createException("input don't match any of types " + Arrays.deepToString((Object[])this.types), "type", in);
            }
            if (!this.nullIsValid) {
                throw ValidationException.createException("input don't match any of types " + Arrays.deepToString((Object[])this.types), "type", in);
            }
        }
    }
}

