/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.VertxException;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.Schema;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidationException
extends VertxException {
    private final String keyword;
    private final Object input;
    private Schema schema;
    private JsonPointer scope;

    protected ValidationException(String message, String keyword, Object input) {
        super(message);
        this.keyword = keyword;
        this.input = input;
    }

    protected ValidationException(String message, Throwable cause, String keyword, Object input) {
        super(message, cause);
        this.keyword = keyword;
        this.input = input;
    }

    public static ValidationException createException(String message, String keyword, Object input, Collection<Throwable> causes) {
        return ValidationException.createException(message + ". Multiple causes: " + ValidationException.formatExceptions(causes), keyword, input);
    }

    public static ValidationException createException(String message, String keyword, Object input, Throwable cause) {
        return new ValidationException(message, cause, keyword, input);
    }

    public static ValidationException createException(String message, String keyword, Object input) {
        return new ValidationException(message, keyword, input);
    }

    public @Nullable String keyword() {
        return this.keyword;
    }

    public Object input() {
        return this.input;
    }

    public Schema schema() {
        return this.schema;
    }

    public JsonPointer scope() {
        return this.scope;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setScope(JsonPointer scope) {
        this.scope = scope;
    }

    public String toString() {
        return "ValidationException{message='" + this.getMessage() + '\'' + ", keyword='" + this.keyword + '\'' + ", input=" + this.input + ", schema=" + this.schema + (this.scope != null ? ", scope=" + this.scope.toURI() : "") + '}';
    }

    private static String formatExceptions(Collection<Throwable> throwables) {
        if (throwables == null) {
            return "[]";
        }
        return "[" + throwables.stream().filter(Objects::nonNull).map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
    }
}

