/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.BaseSingleSchemaValidatorFactory;
import io.vertx.json.schema.common.DefaultApplier;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaImpl;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.ArrayList;

public class ItemsValidatorFactory
extends BaseSingleSchemaValidatorFactory {
    @Override
    protected BaseSingleSchemaValidator instantiate(MutableStateValidator parent) {
        return new ItemsValidator(parent);
    }

    @Override
    protected String getKeyword() {
        return "items";
    }

    class ItemsValidator
    extends BaseSingleSchemaValidator
    implements DefaultApplier {
        public ItemsValidator(MutableStateValidator parent) {
            super(parent);
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            if (in instanceof JsonArray) {
                JsonArray arr = (JsonArray)in;
                for (int i = 0; i < arr.size(); ++i) {
                    context.markEvaluatedItem(i);
                    this.schema.validateSync(context.lowerLevelContext(), arr.getValue(i));
                }
            }
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            if (in instanceof JsonArray) {
                JsonArray arr = (JsonArray)in;
                ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
                for (int i = 0; i < arr.size(); ++i) {
                    context.markEvaluatedItem(i);
                    Future<Void> f = this.schema.validateAsync(context.lowerLevelContext(), arr.getValue(i));
                    if (f.isComplete()) {
                        if (!f.failed()) continue;
                        return Future.failedFuture((Throwable)f.cause());
                    }
                    futs.add(f);
                }
                if (futs.isEmpty()) {
                    return Future.succeededFuture();
                }
                return CompositeFuture.all(futs).compose(cf -> Future.succeededFuture());
            }
            return Future.succeededFuture();
        }

        @Override
        public void applyDefaultValue(Object value) {
            if (value instanceof JsonArray) {
                ((JsonArray)value).forEach(((SchemaImpl)this.schema)::doApplyDefaultValues);
            }
        }
    }
}

