/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;

public class MultipleOfValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Number multipleOf = (Number)schema.getValue("multipleOf");
            return new MultipleOfValidator(multipleOf.doubleValue());
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for multipleOf keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null multipleOf keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("multipleOf");
    }

    class MultipleOfValidator
    extends BaseSyncValidator {
        private final double multipleOf;

        public MultipleOfValidator(double multipleOf) {
            this.multipleOf = multipleOf;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (in instanceof Number && ((Number)in).doubleValue() % this.multipleOf != 0.0) {
                throw ValidationException.createException("provided number should be multiple of " + this.multipleOf, "multipleOf", in);
            }
        }
    }
}

