/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.Future;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseCombinatorsValidator;
import io.vertx.json.schema.common.BaseCombinatorsValidatorFactory;
import io.vertx.json.schema.common.FutureUtils;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.Arrays;
import java.util.stream.Collectors;

public class OneOfValidatorFactory
extends BaseCombinatorsValidatorFactory {
    @Override
    BaseCombinatorsValidator instantiate(MutableStateValidator parent) {
        return new OneOfValidator(parent);
    }

    @Override
    String getKeyword() {
        return "oneOf";
    }

    class OneOfValidator
    extends BaseCombinatorsValidator {
        public OneOfValidator(MutableStateValidator parent) {
            super(parent);
        }

        private boolean isValidSync(SchemaInternal schema, ValidatorContext context, Object in) {
            try {
                schema.validateSync(context, in);
                return true;
            }
            catch (ValidationException e) {
                return false;
            }
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            long validCount = Arrays.stream(this.schemas).map(s -> this.isValidSync((SchemaInternal)s, context, in)).filter(b -> b.equals(true)).count();
            if (validCount > 1L) {
                throw ValidationException.createException("More than one schema valid", "oneOf", in);
            }
            if (validCount == 0L) {
                throw ValidationException.createException("No schema matches", "oneOf", in);
            }
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            return FutureUtils.oneOf(Arrays.stream(this.schemas).map(s -> s.validateAsync(context, in)).collect(Collectors.toList())).recover(err -> Future.failedFuture((Throwable)((Object)ValidationException.createException("No schema matches", "oneOf", in, err))));
        }
    }
}

