/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            String pattern = (String)schema.getValue("pattern");
            return new PatternValidator(Pattern.compile(pattern));
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for pattern keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null pattern keyword", e);
        }
        catch (PatternSyntaxException e) {
            throw new SchemaException(schema, "Invalid pattern in pattern keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("pattern");
    }

    public class PatternValidator
    extends BaseSyncValidator {
        private final Pattern pattern;

        public PatternValidator(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            Matcher m;
            if (in instanceof String && !(m = this.pattern.matcher((String)in)).matches() && !m.lookingAt() && !m.find()) {
                throw ValidationException.createException("provided string should respect pattern " + this.pattern, "pattern", in);
            }
        }
    }
}

