/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.Future;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.RecursiveAnchorValidatorContextDecorator;
import io.vertx.json.schema.common.SchemaImpl;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.URIUtils;
import io.vertx.json.schema.common.ValidatorContext;
import java.net.URI;

public class RecursiveRefSchema
extends SchemaImpl {
    private static final Logger log = LoggerFactory.getLogger(RecursiveRefSchema.class);
    private final JsonPointer refPointer;
    private final SchemaParser schemaParser;

    public RecursiveRefSchema(JsonObject schema, JsonPointer scope, SchemaParser schemaParser, MutableStateValidator parent) {
        super(schema, scope, parent);
        this.schemaParser = schemaParser;
        try {
            String unparsedUri = schema.getString("$recursiveRef");
            this.refPointer = URIUtils.createJsonPointerFromURI(URI.create(unparsedUri));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Parsed %s $recursiveRef for schema %s", this.refPointer, schema));
            }
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null $recursiveRef keyword", e);
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for $recursiveRef keyword", e);
        }
        catch (IllegalArgumentException e) {
            throw new SchemaException(schema, "$recursiveRef URI is invalid: " + e.getMessage(), e);
        }
    }

    @Override
    public Future<Void> validateAsync(ValidatorContext inContext, Object in) {
        SchemaInternal solvedSchema;
        try {
            solvedSchema = this.resolveSchema(inContext);
        }
        catch (SchemaException e) {
            return Future.failedFuture((Throwable)((Object)ValidationException.createException("Error while resolving $recursiveRef " + this.refPointer.toURI(), "$recursiveRef", in, (Throwable)((Object)e))));
        }
        if (solvedSchema == null) {
            return Future.failedFuture((Throwable)((Object)ValidationException.createException("Cannot resolve $recursiveRef " + this.refPointer.toURI(), "$recursiveRef", in)));
        }
        ValidatorContext newContext = this.generateValidationContext(solvedSchema, inContext);
        if (solvedSchema.isSync() && this.isSync) {
            try {
                solvedSchema.validateSync(RecursiveAnchorValidatorContextDecorator.unwrap(newContext));
                this.runSyncValidator(newContext, in);
            }
            catch (ValidationException e) {
                return Future.failedFuture((Throwable)((Object)e));
            }
        }
        return solvedSchema.validateAsync(RecursiveAnchorValidatorContextDecorator.unwrap(newContext), in).compose(v -> this.runAsyncValidators(newContext, in));
    }

    @Override
    public void validateSync(ValidatorContext context, Object in) throws ValidationException {
        this.checkSync();
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public void doApplyDefaultValues(Object obj) {
    }

    @Override
    public boolean isSync() {
        return false;
    }

    @Override
    protected void checkSync() throws ValidationException, NoSyncValidationException {
        throw new NoSyncValidationException("Trying to execute validateSync() for a $recursiveRef schema", this);
    }

    private SchemaInternal resolveSchema(ValidatorContext inContext) {
        return (SchemaInternal)this.schemaParser.getSchemaRouter().resolveCachedSchema(this.refPointer, this.computeScope(inContext), this.schemaParser);
    }

    private JsonPointer computeScope(ValidatorContext context) {
        if (context instanceof RecursiveAnchorValidatorContextDecorator) {
            RecursiveAnchorValidatorContextDecorator decorator = (RecursiveAnchorValidatorContextDecorator)context;
            return decorator.getRecursiveAnchor();
        }
        return this.getScope();
    }

    protected ValidatorContext generateValidationContext(SchemaInternal schema, ValidatorContext parent) {
        ValidatorContext context;
        ValidatorContext validatorContext = context = schema instanceof SchemaImpl && ((SchemaImpl)schema).shouldRecordContext ? parent.startRecording() : parent;
        if (this.recursiveAnchor) {
            return RecursiveAnchorValidatorContextDecorator.wrap(context, this.getScope());
        }
        return context;
    }
}

